{
    $Id: timer.pp,v 1.1.1.1 1998/03/25 11:18:48 root Exp $
    This program is part of the Free Pascal run time library.
    Copyright (c) 1998 by Peter Vreman
    member of the Free Pascal development team

    This unit implements a millisecond timer, can be used with
    go32v2, linux and tp7
    
    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
unit Timer;
interface

type
  TTimer = Object
    TotalMSec,
    StartMSec : longint;
    constructor init;
    procedure reset;
    procedure start;
    procedure stop;
    Function MSec:longint;
    Function HSec:longint;
    Function TSec:longint;
    Function Sec:longint;
    Function Min:longint;
    Function Hour:longint;
  end;

implementation

{$IFDEF LINUX}
  uses Linux;
{$ENDIF}

{****************************************************************************
                     System Dependent Timer (not exported)
****************************************************************************}

{$IFDEF LINUX}

  Procedure InitTimer;
  begin
  end;

  Procedure DoneTimer;
  begin
  end;

  Function MSTimer:Longint;
  var
    tv : TimeVal;
    tz : TimeZone;
  begin
    GetTimeOfDay(tv,tz);
    MSTimer:=(tv.USec div 1000)+tv.Sec*1000;
  end;

{$ELSE}

  {$IFDEF FPK}

  Procedure InitTimer;assembler;
  asm
        movl    $0x34,%eax
        outb    %al,$0x43
        .word   235
        xorl    %eax,%eax
        outb    %al,$0x40
        .word   235
        outb    %al,$0x40
  end;

  Procedure DoneTimer;assembler;
  asm
        movl    $0x36,%eax
        outb    %al,$0x43
        .word   235
        xorl    %eax,%eax
        outb    %al,$0x40
        .word   235
        outb    %al,$0x40
  end;

  Function MSTimer:longint;assembler;
  asm
        pushl   %esi
        pushl   %edi
        cli
        movl    $0xa,%eax
        outb    %al,$0x20
        xorl    %eax,%eax
        outb    %al,$0x43
        inb     $0x20,%al
        movl    %eax,%edi
        inb     $0x40,%al
        movl    %eax,%ebx
        inb     $0x40,%al
        movb    %al,%bh
        notl    %ebx
        inb     $0x21,%al
        movl    %eax,%esi
        movl    $0xff,%eax
        outb    %al,$0x21
        movl    $0x46C,%edx
        movl    %fs:(%edx),%edx
        movl    %esi,%eax
        outb    %al,$0x21
        sti
        movl    %edi,%eax
        testl   $1,%eax
        jz      .LMSTimerDone
        cmp     $0xff,%bx
        ja      .LMSTimerDone
        incl    %edx
.LMSTimerDone:
        shll    $16,%edx
        movl    %edx,%eax
        movw    %bx,%ax
        popl    %edi
        popl    %esi
        xorl    %edx,%edx
        movl    $1193,%ecx
        divl    %ecx
  end;

  {$ELSE}

  Procedure InitTimer;assembler;
  asm
                mov     al,34h
                out     43h,al
                xor     al,al
                out     40h,al
                out     40h,al
  end;

  Procedure DoneTimer;assembler;
  asm
                mov     al,36h
                out     43h,al
                xor     al,al
                out     40h,al
                out     40h,al
  end;

  Function MSTimer:longint;assembler;
  asm
                push    40h
                pop     es
                pushf
                cli
                mov     di,es:[6ch]
                mov     cx,es:[6eh]
                sti
                mov     al,4
                out     43h,al
                cli
                mov     si,es:[6ch]
                mov     bx,es:[6eh]
                in      al,40h
                mov     ah,al
                in      al,40h
                popf
                xchg    al,ah
                cmp     di,si
                je      @@10
                or      ax,ax
                jns     @@10
                mov     di,si
                mov     cx,bx
@@10:           not     ax
                mov     bx,36edh
                mul     bx
                mov     si,dx
                mov     ax,bx
                mul     di
                xchg    bx,ax
                mov     di,dx
                add     bx,si
                adc     di,0
                xor     si,si
                mul     cx
                add     ax,di
                adc     dx,si
                mov     dh,dl
                mov     dl,ah
                mov     ah,al
                mov     al,bh
                mov     di,dx
                mov     cx,ax
                mov     ax,25110
                mul     dx
                sub     cx,dx
                sbb     di,si
                xchg    ax,cx
                mov     dx,di
  end;

  {$ENDIF}

{$ENDIF}

{****************************************************************************
                             Easy Timing Functions
****************************************************************************}

procedure TTimer.Reset;
begin
  TotalMSec:=0;
  StartMSec:=0;
end;

procedure TTimer.Start;
begin
  StartMSec:=MSTimer;
end;


procedure TTimer.Stop;
var
  EndMSec : longint;
begin
  EndMSec:=MSTimer;
  if StartMSec>EndMSec then
   inc(EndMSec,86400000); {Total Msecs in 24h}
  inc(TotalMSec,EndMSec-StartMSec);
end;


Function TTimer.MSec:longint;
begin
  MSec:=TotalMSec;
end;

Function TTimer.HSec:longint;
begin
  HSec:=TotalMSec div 10;
end;

Function TTimer.TSec:longint;
begin
  TSec:=TotalMSec div 100;
end;

Function TTimer.Sec:longint;
begin
  Sec:=TotalMSec div 1000;
end;

Function TTimer.Min:longint;
begin
  Min:=TotalMSec div 60000;
end;

Function TTimer.Hour:longint;
begin
  Hour:=TotalMSec div 3600000;
end;

Constructor TTimer.Init;
begin
  InitTimer;
  Reset;
end;

end.
{
  $Log: timer.pp,v $
  Revision 1.1.1.1  1998/03/25 11:18:48  root
  * Restored version

  Revision 1.6  1998/03/11 12:16:46  peter
    * ttimer.init does also a reset

  Revision 1.5  1998/02/24 16:50:09  peter
    * stackframe ommiting generated 'ret $-4'
    + timer.pp bp7 version
    * innr.inc are now the same files

  Revision 1.4  1998/01/26 19:22:55  peter
    + Removed Overloaded functions, only longint returns are left

  Revision 1.3  1998/01/26 12:03:03  michael
    + Added log at the end

  Revision 1.2  1998/01/26 11:39:24  michael
    * Removed CR at end of line.

  Revision 1.1  1998/01/25 21:56:19  peter
    * First implementation, works under go32 and linux
}
