{
    $Id: ppudump.pp,v 1.10 1998/09/01 17:35:33 peter Exp $
    Copyright (c) 1995-98 by the FPC Development Team

    Dumps the contents of a FPC unit file (PPU File)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************}
{$ifdef TP}
  {$N+,E+}
{$endif}
program pppdump;
uses ppu;

const
  Version   = 'Version 0.99.6';
  Title     = 'PPU-Analyser';
  Copyright = 'Copyright (c) 1995-98 by the Free Pascal Development Team';

{ verbosity }
  v_none           = $0;
  v_header         = $1;
  v_defs           = $2;
  v_syms           = $4;
  v_interface      = $8;
  v_implementation = $10;
  v_browser        = $20;
  v_all            = $ff;

var
  ppufile     : pppufile;
  space       : string;
  procoptions,
  symcnt,
  defcnt      : longint;
  object_options,
  read_member : boolean;
  verbose     : longint;

{****************************************************************************
                          Helper Routines
****************************************************************************}

Function Target2Str(cpu,w:longint):string;
const
  Targeti386 : array[0..4] of string[10]=('GO32V1','GO32V2','Linux-i386','OS/2','Win32');
  Targetm68k : array[0..3] of string[10]=('Amiga','Mac68k','Atari','Linux-m68k');
begin
  Target2Str:='<Unknown>';
  case cpu of
   0 : if w<=4 then
        Target2Str:=Targeti386[w];
   1 : if w<=3 then
        Target2Str:=Targetm68k[w];
  end;
end;


Function Cpu2Str(w:longint):string;
const
  CpuTxt : array[0..2] of string[5]=('i386','m68k','alpha');
begin
  if w<=7 then
   Cpu2Str:=CpuTxt[w]
  else
   Cpu2Str:='<Unknown>';
end;


const
  HexTbl : array[0..15] of char='0123456789ABCDEF';
function HexB(b:byte):string;
begin
  HexB[0]:=#2;
  HexB[1]:=HexTbl[b shr 4];
  HexB[2]:=HexTbl[b and $f];
end;

{****************************************************************************
                             Read Routines
****************************************************************************}

Procedure ReadContainer(const prefix:string);
{
  Read a serie of strings and write to the screen starting every line
  with prefix
}
begin
  while not ppufile^.endofentry do
   WriteLn(prefix,ppufile^.getstring);
end;


Procedure ReadRef;
begin
  if (verbose and v_browser)=0 then
   exit;
  while (not ppufile^.endofentry) and (not ppufile^.error) do
   Writeln(space,'        - Refered : ',ppufile^.getword,', (',ppufile^.getlongint,',',ppufile^.getword,')');
end;


procedure readdefref;
var
  w : word;
begin
  w:=ppufile^.getword;
  if w=$ffff then
    begin
       w:=ppufile^.getword;
       if w=$ffff then
        writeln('nil')
       else
        writeln('Local Definition Nr. ',w)
    end
  else
    writeln('Unit ',w,'  Definition Nr. ',ppufile^.getword)
end;


procedure readsymref;
var
  w : word;
begin
  w:=ppufile^.getword;
  if w=$ffff then
    begin
       w:=ppufile^.getword;
       if w=$ffff then
        writeln('nil')
       else
        writeln('Local Symbol Nr. ',w)
    end
  else
    writeln('Unit ',w,'  Symbol Nr. ',ppufile^.getword)
end;


procedure read_abstract_proc_def;
var
  params : word;
begin
  write(space,'      Return type : ');
  readdefref;
  procoptions:=ppufile^.getlongint;
  if procoptions<>0 then
   begin
     write(space,'          Options : ');
     if (procoptions and 1)<>0 then
      write('Exception handler ');
     if (procoptions and 2)<>0 then
      write('Virtual Method ');
     if (procoptions and 4)<>0 then
      write('Stack is not cleared ');
     if (procoptions and 8)<>0 then
      write('Constructor ');
     if (procoptions and $10)<>0 then
      write('Destructor ');
     if (procoptions and $20)<>0 then
      write('Internal Procedure ');
     if (procoptions and $40)<>0 then
      write('Exported Procedure ');
     if (procoptions and $80)<>0 then
      write('I/O-Checking ');
     if (procoptions and $100)<>0 then
      write('Abstract method ');
     if (procoptions and $200)<>0 then
      write('Interrupt Handler ');
     if (procoptions and $400)<>0 then
      write('Inline Procedure ');
     if (procoptions and $800)<>0 then
      write('Assembler Procedure ');
     if (procoptions and $1000)<>0 then
      write('Overloaded Operator ');
     if (procoptions and $2000)<>0 then
      write('External Procedure ');
     if (procoptions and $4000)<>0 then
      write('Expects parameters from left to right ');
     if (procoptions and $8000)<>0 then
      write('Main Program ');
     if (procoptions and $10000)<>0 then
      write('Static Method ');
     if (procoptions and $20000)<>0 then
      write('Method with Override Directive ');
     if (procoptions and $40000)<>0 then
      write('Class Method ');
     if (procoptions and $80000)<>0 then
      write('Unit Initialisation ');
     if (procoptions and $100000)<>0 then
      write('Method Pointer ');
     if (procoptions and $200000)<>0 then
      write('C Declaration ');
     if (procoptions and $400000)<>0 then
      write('PalmOS Syscall ');
     if (procoptions and $800000)<>0 then
      write('Has internal Constant Function ');
     writeln;
   end;
  params:=ppufile^.getword;
  writeln(space,' Nr of parameters : ',params);
  if params>0 then
   begin
     repeat
       write(space,'       - Type ',ppufile^.getbyte,' ');
       readdefref;
       dec(params);
     until params=0;
   end;
end;


{****************************************************************************
                             Read Symbols Part
****************************************************************************}

procedure readsymbols;

  procedure readcommonsym(const s:string);
  begin
    with ppufile^ do
     begin
       write(space,'Type symbol ',getstring);
       if Object_options then
        write(' (Options: ',getbyte,')');
       writeln;
     end;
  end;

Type
  absolutetyp = (tovar,toasm,toaddr);
  tconsttype  = (constord,conststring,constreal,constbool,constint,constchar,constseta);
var
  b      : byte;
  symcnt,
  i,j    : longint;
begin
  symcnt:=0;
  with ppufile^ do
   begin
     repeat
       b:=readentry;
       if not (b in [iberror,ibendsyms]) then
        begin
          writeln(space,'** Symbol Nr. ',symcnt,' **');
          inc(symcnt);
        end;
       case b of
           ibtypesym : begin
                         readcommonsym('Type symbol ');
                         write(space,'  Definition: ');
                         readdefref;
                       end;
           ibprocsym : begin
                         readcommonsym('Procedure symbol ');
                         write(space,'  Definition: ');
                         readdefref;
                       end;
          ibconstsym : begin
                         readcommonsym('Constant symbol ');
                         b:=getbyte;
                         case tconsttype(b) of
                   constord : begin
                                write (space,'  Definition : ');
                                readdefref;
                                writeln (space,'  Value : ',getlongint)
                              end;
                conststring : writeln(space,'  Value : "'+getstring+'"');
                  constreal : writeln(space,'  Value : ',getreal);
                  constbool : if getlongint<>0 then
                               writeln (space,'  Value : True')
                              else
                               writeln (space,'  Value : False');
                   constint : writeln(space,'  Value : ',getlongint);
                  constchar : writeln(space,'  Value : "'+chr(getlongint)+'"');
                  constseta : begin
                                write (space,'  Definition : ');
                                readdefref;
                                for i:=1to 4 do
                                 begin
                                   write (space,'  Value : ');
                                   for j:=1to 8 do
                                    begin
                                      if j>1 then
                                       write(',');
                                      write(hexb(getbyte));
                                    end;
                                   writeln;
                                 end;
                              end;
                         else
                           Writeln ('Invalid unit format : Invalid const type encountered: ',b);
                         end;
                       end;
            ibvarsym : begin
                         readcommonsym('Variable symbol ');
                         writeln(space,'        Type: ',getbyte);
                         if read_member then
                           writeln(space,'     Address: ',getlongint);
                         write(space,'  Definition: ');
                         readdefref;
                       end;
           ibenumsym : begin
                         readcommonsym('Enumeration symbol ');
                         write(space,'  Definition: ');
                         readdefref;
                         writeln(space,'  Value : ',getlongint);
                       end;
     ibtypedconstsym : begin
                         readcommonsym('Typed constant ');
                         write(space,'  Definition: ');
                         readdefref;
                         writeln(space,'  Label: ',getstring);
                       end;
       ibabsolutesym : begin
                         readcommonsym('Absolute variable symbol ');
                         writeln(space,'        Type: ',getbyte);
                         if read_member then
                           writeln(space,'     Address: ',getlongint);
                         write(space,'  Definition: ');
                         readdefref;
                         b:=getbyte;
                         Write (space,'  Relocated to ');
                         case absolutetyp(b) of
                           tovar : Writeln ('Name : ',getstring);
                           toasm : Writeln ('Assembler name : ',getstring);
                          toaddr : Writeln ('Address : ',getlongint);
                         else
                           Writeln ('Invalid unit format : Invalid absolute type encountered: ',b);
                         end;
                       end;
       ibpropertysym : begin
                         readcommonsym('Property ');
                         write(space,'  Definition: ');
                         readdefref;
                         writeln(space,'   Options : ',getlongint);
                         writeln(space,'     Index : ',getlongint);
                         writeln(space,' Read Name : ',getstring);
                         writeln(space,'Write Name : ',getstring);
                         write(space,' Read Definition : ');
                         readdefref;
                         write(space,'Write Definition : ');
                         readdefref;
                       end;
             iberror : begin
                         Writeln('Error in PPU');
                         exit;
                       end;
           ibendsyms : break;
       else
        WriteLn('!! Skipping unsupported PPU Entry in Symbols: ',b);
       end;
       if not EndOfEntry then
        Writeln('!! Entry has more information stored');
     until false;
   end;
end;


{****************************************************************************
                         Read defintions Part
****************************************************************************}

procedure readdefinitions;
type
  tsettype = (normset,smallset,varset);
  tbasetype = (uauto,uvoid,uchar,
               u8bit,u16bit,u32bit,
               s8bit,s16bit,s32bit,
               bool8bit,bool16bit,bool32bit);
var
  b : byte;
  oldread_member : boolean;
  defcnt : longint;
begin
  defcnt:=0;
  with ppufile^ do
   begin
     repeat
       b:=readentry;
       if not (b in [iberror,ibenddefs]) then
        begin
          writeln(space,'** Definition Nr. ',defcnt,' **');
          inc(defcnt);
        end;
       case b of
        ibpointerdef : begin
                         write(space,'Pointerdefinition to : ');
                         readdefref;
                       end;
            iborddef : begin
                         write(space,'Base type ');
                         case tbasetype(getbyte) of
                          uauto : writeln('uauto');
                          uvoid : writeln('uvoid');
                          uchar : writeln('uchar');
                          u8bit : writeln('u8bit');
                         u16bit : writeln('u16bit');
                         u32bit : writeln('s32bit');
                          s8bit : writeln('s8bit');
                         s16bit : writeln('s16bit');
                         s32bit : writeln('s32bit');
                       bool8bit : writeln('bool8bit');
                      bool16bit : writeln('bool16bit');
                      bool32bit : writeln('bool32bit');
                         end;
                         writeln(space,'  Range: ',getlongint,' to ',getlongint);
                       end;
          ibfloatdef : begin
                         writeln (space,'Float definition');
                         writeln (space, '  Float type: ',getbyte);
                       end;
          ibarraydef : begin
                         writeln(space,'Array definition');
                         write  (space,'  Element type: ');
                         readdefref;
                         write  (space,'    Range Type: ');
                         readdefref;
                         writeln(space,'         Range: ',getlongint,' to ',getlongint);
                       end;
           ibprocdef : begin
                         writeln(space,'Procedure definition : ');
                         read_abstract_proc_def;
                         writeln(space,' Used Register: ',getbyte);
                         writeln(space,'  Mangled name: ',getstring);
                         writeln(space,'        Number: ',getlongint);
                         write  (space,'          Next: ');
                         readdefref;
                         getlongint;
                       end;
        ibprocvardef : begin
                         writeln(space,'Procedural type : ');
                         read_abstract_proc_def;
                       end;
         ibstringdef : begin
                         writeln(space,'String definition with length: ',getbyte);
                       end;
     ibwidestringdef : begin
                         writeln (space,'WideString definition with length: ',getlongint);
                       end;
     ibansistringdef : begin
                         writeln (space,'AnsiString definition with length: ',getlongint);
                       end;
     iblongstringdef : begin
                         writeln (space,'Longstring definition with length: ',getlongint);
                       end;
         ibrecorddef : begin
                         writeln(space,'Record definition with size ',getlongint);
                         space:='    '+space;
                       {read the record definitions and symbols}
                         oldread_member:=read_member;
                         read_member:=true;
                         readdefinitions;
                         readsymbols;
                         read_member:=oldread_member;
                         Delete(space,1,4);
                       end;
         ibobjectdef : begin
                         writeln(space,'Class definition with size ',getlongint);
                         writeln(space,'   Name of Class : ',getstring);
                         write(space,  '  Ancestor Class : ');
                         readdefref;
                         writeln(space,'         Options : ',getlongint);
                         space:='    '+space;
                       {read the record definitions and symbols}
                         object_options:=true;
                         oldread_member:=read_member;
                         read_member:=true;
                         readdefinitions;
                         readsymbols;
                         read_member:=oldread_member;
                         object_options:=false;
                         Delete(space,1,4);
                       end;
           ibfiledef : begin
                         case getbyte of
                          0 : writeln(space,'Text file definition');
                          1 : begin
                                write(space,'Typed file definition of Type : ');
                                readdefref;
                              end;
                          2 : writeln(space,'Untyped file definition');
                         end;
                       end;
         ibformaldef : begin
                         writeln(space,'Generic Definition (void-typ)');
                       end;
           ibenumdef : begin
                         writeln(space,'Enumeration type definition');
                         write(space,'Base enumeration type: ');
                         readdefref;
                         writeln(space,'   Smallest element: ',getlongint);
                         writeln(space,'    Largest element: ',getlongint);
                         writeln(space,'               Size: ',getlongint);
                       end;
       ibclassrefdef : begin
                         write(space,'Class reference definition to: ');
                         readdefref;
                       end;
            ibsetdef : begin
                         writeln(space,'Set definition');
                         write  (space,'  Element type: ');
                         readdefref;
                         b:=getbyte;
                         case tsettype(b) of
                          smallset : writeln(space,'  Set with 32 Elements');
                           normset : writeln(space,'  Set with 256 Elements');
                            varset : writeln(space,'  Set with ',getlongint,' Elements');
                         else
                           writeln('!! Warning: Invalid set type ',b);
                         end;
                       end;
             iberror : begin
                         Writeln('Error in PPU');
                         exit;
                       end;
           ibenddefs : break;
       else
        WriteLn('!! Skipping unsupported PPU Entry in defintions: ',b);
       end;
       if not EndOfEntry then
        Writeln('!! Entry has more information stored');
     until false;
   end;
end;


{****************************************************************************
                           Read General Part
****************************************************************************}

procedure readinterface;
var
  b : byte;
  unitnumber : word;
begin
  with ppufile^ do
   begin
     repeat
       b:=readentry;
       case b of
        ibmodulename : Writeln('Module Name: ',getstring);
       ibsourcefiles : begin
                         while not EndOfEntry do
                          Writeln('Source file: ',getstring);
                       end;
      ibloadunit_int : begin
                         unitnumber:=1;
                         while not EndOfEntry do
                          begin
                            write('Uses unit: ',getstring,
                                    ' (Number: ',unitnumber,') (Checksum: ',getlongint,')');
                            if getbyte<>0 then
                             writeln(' (interface)')
                            else
                             writeln(' (implementation)');
                            inc(unitnumber);
                          end;
                       end;
        iblinkofiles : ReadContainer('Link object file: ');
    iblinkstaticlibs : ReadContainer('Link static lib: ');
    iblinksharedlibs : ReadContainer('Link shared lib: ');
             iberror : begin
                         Writeln('Error in PPU');
                         exit;
                       end;
      ibendinterface : break;
       else
        WriteLn('!! Skipping unsupported PPU Entry in General Part: ',b);
       end;
     until false;
   end;
end;


{****************************************************************************
                        Read Implementation Part
****************************************************************************}

procedure readimplementation;
var
  b : byte;
  unitnumber : word;
begin
  with ppufile^ do
   begin
     repeat
       b:=readentry;
       case b of
      ibloadunit_imp : begin
                         unitnumber:=0;
                         while not EndOfEntry do
                          begin
                            writeln('Uses unit (implementation): ',getstring,
                                    ' (Number: ',unitnumber,') (Checksum: ',getlongint,')');
                            inc(unitnumber);
                          end;
                       end;
             iberror : begin
                         Writeln('Error in PPU');
                         exit;
                       end;
 ibendimplementation : break;
       else
        WriteLn('!! Skipping unsupported PPU Entry in Implementation: ',b);
       end;
     until false;
   end;
end;


{****************************************************************************
                            Read Browser Part
****************************************************************************}

procedure readbrowser;
var
  b : byte;
begin
  with ppufile^ do
   begin
     repeat
       b:=readentry;
       case b of
            ibsymref : begin
                         readsymref;
                         readref;
                       end;
            ibdefref : begin
                         readdefref;
                         readref;
                       end;
             iberror : begin
                         Writeln('Error in PPU');
                         exit;
                       end;
        ibendbrowser : break;
       else
        WriteLn('!! Skipping unsupported PPU Entry in Browser: ',b);
       end;
     until false;
   end;
end;




procedure dofile (filename : string);
begin
{ reset }
  space:='';
  defcnt:=0;
  symcnt:=0;
{ fix filename }
  if pos('.',filename)=0 then
   filename:=filename+'.ppu';
  ppufile:=new(pppufile,Init(filename));
  if not ppufile^.open then
   begin
     writeln ('IO-Error when opening : ',filename,', Skipping');
     exit;
   end;
{ PPU File is open, check for PPU Id }
  if not ppufile^.CheckPPUID then
   begin
     writeln(Filename,' : Not a valid PPU file, Skipping');
     exit;
   end;
{ Check PPU Version }
  Writeln('Analyzing ',filename,' (v',ppufile^.GetPPUVersion,')');
  if ppufile^.GetPPUVersion<15 then
   begin
     writeln(Filename,' : Old PPU Formats (<15) are not supported, Skipping');
     exit;
   end;
{ Write PPU Header Information }
  if (verbose and v_header)<>0 then
   begin
     Writeln;
     Writeln('Header');
     Writeln('-------');
     with ppufile^.header do
      begin
        Writeln('Compiler version        : ',hi(ppufile^.header.compiler and $ff),'.',lo(ppufile^.header.compiler));
        WriteLn('Target processor        : ',Cpu2Str(cpu));
        WriteLn('Target operating system : ',Target2Str(cpu,target));
        Write  ('Unit flags              : ',flags,', ');
          if (flags and uf_init)<>0 then
           write('init ');
          if (flags and uf_big_endian)<>0 then
           write('big_endian ');
          if (flags and uf_finalize)<>0 then
           write('finalize ');
          if (flags and uf_has_dbx)<>0 then
           write('has_dbx ');
          if (flags and uf_has_browser)<>0 then
           write('has_browser ');
          if (flags and uf_smartlink)<>0 then
           write('smartlink ');
          if (flags and uf_in_library)<>0 then
           write('in_library ');
          if (flags and uf_shared_linked)<>0 then
           write('shared_linked ');
          if (flags and uf_static_linked)<>0 then
           write('static_linked ');
          if (flags=0) then
           write('(none)');
          writeln;
        Writeln('FileSize (w/o header)   : ',size);
        Writeln('Checksum                : ',checksum);
      end;
   end;
{read the general stuff}
  if (verbose and v_interface)<>0 then
   begin
     Writeln;
     Writeln('Interface section');
     Writeln('------------------');
     readinterface;
   end
  else
   ppufile^.skipuntilentry(ibendinterface);
{read the definitions}
  if (verbose and v_defs)<>0 then
   begin
     Writeln;
     Writeln('Interface definitions');
     Writeln('----------------------');
     readdefinitions;
   end
  else
   ppufile^.skipuntilentry(ibenddefs);
{read the symbols}
  if (verbose and v_syms)<>0 then
   begin
     Writeln;
     Writeln('Interface Symbols');
     Writeln('------------------');
     readsymbols;
   end
  else
   ppufile^.skipuntilentry(ibendsyms);
{read the browser stuff}
  if (ppufile^.header.flags and uf_has_browser)<>0 then
   begin
     if (verbose and v_browser)<>0 then
      begin
        Writeln;
        Writeln('Browser section');
        Writeln('-----------------------');
        readbrowser;
      end
     else
      ppufile^.skipuntilentry(ibendbrowser);
   end;
{read the implementation stuff}
  if (verbose and v_implementation)<>0 then
   begin
     Writeln;
     Writeln('Implementation section');
     Writeln('-----------------------');
     readimplementation;
   end
  else
   ppufile^.skipuntilentry(ibendimplementation);
{shutdown ppufile}
  ppufile^.close;
  dispose(ppufile,done);
  Writeln;
end;



procedure help;
begin
  writeln('usage: dumpppu [options] <filename1> <filename2>...');
  writeln;
  writeln('[options] can be:');
  writeln('    -V<verbose>  Set verbosity to <verbose>');
  writeln('                   H - Show header info');
  writeln('                   I - Show interface');
  writeln('                   M - Show implementation');
  writeln('                   S - Show interface symbols');
  writeln('                   D - Show interface definitions');
  writeln('                   B - Show browser info');
  writeln('                   A - Show all');
  writeln('    -?           This helpscreen');
  halt;
end;

var
  startpara,
  nrfile,i  : longint;
  para      : string;
begin
  writeln(Title+' '+Version);
  writeln(Copyright);
  writeln;
  if paramcount<1 then
   begin
     writeln('usage: dumpppu [options] <filename1> <filename2>...');
     halt(1);
   end;
{ turn verbose on by default }
  verbose:=v_all;
{ read options }
  startpara:=1;
  while copy(paramstr(startpara),1,1)='-' do
   begin
     para:=paramstr(startpara);
     case upcase(para[2]) of
      'V' : begin
              verbose:=0;
              for i:=3to length(para) do
               case upcase(para[i]) of
                'H' : verbose:=verbose or v_header;
                'I' : verbose:=verbose or v_interface;
                'M' : verbose:=verbose or v_implementation;
                'D' : verbose:=verbose or v_defs;
                'S' : verbose:=verbose or v_syms;
                'B' : verbose:=verbose or v_browser;
                'A' : verbose:=verbose or v_all;
               end;
            end;
      '?' : help;
     end;
     inc(startpara);
   end;
{ process files }
  for nrfile:=startpara to paramcount do
   dofile (paramstr(nrfile));
end.
{
  $Log: ppudump.pp,v $
  Revision 1.10  1998/09/01 17:35:33  peter
    * update for new po's

  Revision 1.9  1998/09/01 12:46:52  peter
    + enum savesize

  Revision 1.8  1998/08/26 10:01:18  peter
    + set support

  Revision 1.7  1998/08/20 13:01:41  peter
    + object_options, new enumdef

  Revision 1.6  1998/08/17 10:26:28  peter
    * updated for new shared/static style

  Revision 1.5  1998/08/13 10:56:28  peter
    * check if a whole entry is read
    + support for constset

  Revision 1.4  1998/08/11 15:31:44  peter
    * write extended to ppu file
    * new version 0.99.7

  Revision 1.3  1998/07/10 10:59:17  peter
    + m68k target support

  Revision 1.2  1998/06/17 13:58:28  peter
    + symbol/def nrs are now listed

  Revision 1.1  1998/06/13 00:05:01  peter
    + new util to dump v15+ ppu

}
