#!/bin/sh
#
# Free Pascal installation script for Linux.
# Michael Van Canneyt, 1998
#
# Don't edit this file. 
# Everything can be set when the script is run.
#

# some useful functions
# ask displays 1st parameter, and ask new value for variable, whose name is
# in the second parameter.
ask ()
{
askvar=$2
eval old=\$$askvar
eval echo -n \""$1 [$old] : "\" 
read $askvar
eval test -z \"\$$askvar\" && eval $askvar=\'$old\'
}
# yesno gives 1 on no, 0 on yes $1 gives text to display.
yesno ()
{
  while true; do
  echo -n "$1 (Y/N) ? "
  read ans
  case $ans in
   y|Y) return 0;;
   n|N) return 1;;
  esac
  done
}

# Untar files ($3,optional) from  file ($1) to the given directory ($2)
unztar ()
{
 tar -xzf ${HERE}/$1 --directory $2 $3
}

# Make all the necessary directories to get $1
makedirhierarch ()
{
  OLDDIR=`pwd`
  case $1 in
    /*) cd /;;
  esac
  OLDIFS=$IFS;IFS=/;eval set $1; IFS=$OLDIFS
  for i
  do
    test -d $i || mkdir $i || break
    cd $i ||break
  done
  cd $OLDDIR
}

# check to see if something is in the path
checkpath ()
{
 ARG=$1
 OLDIFS=$IFS; IFS=":";eval set $PATH;IFS=$OLDIFS
 for i
 do
   if [ $i = $ARG ]; then
     return 0
   fi
 done 
 return 1
}

checkpackage ()
{
if [ -e $1 ]; then
  echo "Package $2 found."
  return 0
else
  echo "Package $2 NOT found. Skipping."
  return 1
fi
}

# Here we start the thing.

# Set some defaults.

VERSION=0.99.8
LIBDIR=/usr/lib/fpc/$VERSION
SRCDIR=/usr/src/fpc-$VERSION
DOCDIR=/usr/doc/fpc
DEMODIR=./demo

HERE=`pwd`
RMGCCLIB=YES
if checkpath /usr/local/bin; then
   EXECDIR=/usr/local/bin
else
   EXECDIR=/usr/bin
fi

# welcome message.
clear
echo "This shell script will attempt to install the Free Pascal compiler"
echo "version $VERSION" in the directories of your choice.
echo 
echo "Any previous versions will be overwritten WITHOUT warning !"
echo

# Install libraries. Mandatory.

if [ -e libs.tar.gz ]; then
  ask "Install libraries in" LIBDIR 
  echo Installing libraries in $LIBDIR ...
  makedirhierarch $LIBDIR
  unztar libs.tar.gz $LIBDIR
  echo Attempting to move shared library...
  mv -f $LIBDIR/libfpc.so /usr/lib >/dev/null 2>&1
  if [ $? = 0 ]; then
     ldconfig >/dev/null 2>&1
     if [ $? = 0 ]; then
       echo Succesfully moved shared library to /usr/lib.
     else
       echo Failed. Please move $LIBDIR/libfpc.so to /usr/lib and run ldconfig.
     fi
  else
     echo Failed. Please move $LIBDIR/libfpc.so to /usr/lib and run ldconfig.
  fi
  echo
else
  Could not find required file libs.tar.gz. Exiting.
  exit 1
fi

# Install the program. Mandatory.

ask "Install programs in (absolute path) " EXECDIR
echo Installing programs in $EXECDIR ...
makedirhierarch $EXECDIR
ln -sf ${LIBDIR}/ppc386 ${EXECDIR}/ppc386
if checkpackage bins.tar.gz "Utility binaries" ; then 
  echo Installing utilities.
  tar -xzf bins.tar.gz -C ${EXECDIR}
fi  
echo Done.
echo

# Install the sources. Optional.
if checkpackage sources.tar.gz Sources ; then
  if yesno "Install sources"; then
    ask "Install sources in" SRCDIR
    echo Installing sources in $SRCDIR ...
    makedirhierarch $SRCDIR
    unztar sources.tar.gz $SRCDIR
    echo Done.
  # set the demo dir here to source tree, because we know that sources are installed.
    DEMODIR=$SRCDIR/demo
  fi
fi
echo

# Install the documentation. Optional.
if checkpackage docs.tar.gz Documentation ; then
  if yesno "Install documentation"; then
    ask "Install documentation in" DOCDIR
    echo Installing documentation in $DOCDIR ...
    makedirhierarch $DOCDIR
    unztar docs.tar.gz $DOCDIR
    echo Done.
  fi
fi
echo

# Install the demos. Optional.
if checkpackage demo.tar.gz Demos ; then
  if yesno "Install demos"; then
    ask "Install demos in" DEMODIR
    echo Installing demos in $DEMODIR ...
    makedirhierarch $DEMODIR
    unztar demo.tar.gz $DEMODIR
    echo Done.
  fi
fi
echo

# Install and check for libgcc.a. Optional, since we have a NATIVE version.
echo "If you want to link programs using the C libraries, you will need a
copy"
echo "of libgcc.a."
echo "It is recommended that in this case you let the install program check"
echo "if there is a copy of libgcc.a, and if not, install one."
echo
if yesno "Check for and optionally install libgcc.a"; then
# Tricky. Try to determine where glibcc.a is.
echo Trying to find libgcc.a...
LIBGCCDIR=`find /usr/lib -name libgcc.a -exec dirname {} \; | tail -1`
if [ -z $LIBGCCDIR ]; then
 echo "Could not find libgcc.a in a subdirectory of /usr/lib."
 echo "In the distribution a libgcc.a is included (ELF, GCC version 2.7.2)."
 echo "You can decide to put this included version in /usr/lib,"
 echo "or you can enter the path to libgcc.a manually."
 echo
 if yesno "Do you want to enter the path to libgcc.a yourself"; then
   ask "Please enter the correct path to libgcc.a" LIBGCCDIR
 else
   echo "OK. Using default libgcc.a in $LIBDIR"
   RMGCCLIB=NO
 fi
fi

if [ $RMGCCLIB = YES ]; then
  rm $LIBDIR/libgcc.a
  echo "Using $LIBGCCDIR as the path to libgcc.a."
  yesno "Is this correct" || ask "Please enter another path to libgcc.a" LIBGCCDIR
else
  LIBGCCDIR=$LIBDIR
fi

fi 
# end of libgcc.a part.

echo
echo 'Checking for as...' 
AS=`find /usr/bin -name as -exec dirname {} \; | head -1`
if [ -z $AS ]; then
  echo Could not find "as" under /usr/bin. You need as in order to assemble
  echo your programs. If "as" is installed in another directory, you will
  echo have to specify this using the command line switch \-e.
  echo
else
  echo Found.
fi

echo 'Checking for ld...' 
LD=`find /usr/bin -name ld -exec dirname {} \; | head -1`
if [ -z $LD ]; then
  echo Could not find "ld" under /usr/bin. You need ld in order to link
  echo your programs. If "ld" is installed in another directory, you will
  echo have to specify this using the command line switch \-e.
  echo
else
  echo Found.
fi

echo 'Checking for make...'
MAKE=`find /usr/bin -name as -exec dirname {} \; | head -1`
if [ -z $MAKE ]; then
  echo Could not find "make" under /usr/bin. You don\'t explicitly need make
  echo to compile your programs, but you need it for easy recompilation of
  echo the compiler. 
  echo
else
  echo Found.
fi

echo
echo Making configuration file: ppc386.cfg
echo Executing ${LIBDIR}/samplecfg...
${LIBDIR}/samplecfg
echo Done.
echo
echo Creating README file in current directory.
cat <<EOFREADME >README
This is the README file for the Free Pascal compiler for Linux installation.

REQUIREMENTS:

You need nothing but a standard Linux system, the "as" assembler and the
"ld" linker. You do not need GNU CC.

COMPILING THE DEMOS:

If you decide to install the demos, you can compile them easily doing a
cd demo
ppc386 file.pp
(replace "demo" by the directory where you installed the demos, and "file"
with the name of the demo you wish to compile)
Alternatively, if you have GNU make installed, do a 
cd demo 
make all

Enjoy !

Michael Van Canneyt (michael@tfdec1.fys.kuleuven.ac.be)
EOFREADME
echo Creating README.ENVVAR in current directory.
cat <<EOFREAMEENVVAR >>README.ENVVAR
The Linux port of the Free Pascal Compiler uses the following environment
variables :

PPC_EXEC_PATH   : Contains the directory where 'as' and 'ld' are. (default /usr/bin)
PPC_GCCLIB_PATH : Contains the directory where libgcc.a is (no default)
PPC_CONFIG_PATH : an alternate path to find ppc386.cfg (default /etc)
PPC_ERROR_FILE  : The path and name of the error-definition file. 
                  (default /usr/lib/ppc/errorE.msg)

All these can be replaced by command line switches (-e -Fg, @ , -Fr
respectively)
They are set in the sample configuration file which is built at the end of
installation.

Michael Van Canneyt. (michael@tfdec1.fys.kuleuven.ac.be)
EOFREADMEENVVAR
echo
echo End of installation. 
echo
echo Refer to the documentation for more information. Specifically, see
echo README.ENVVAR for info about environment variables.

