/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: report_error.c,v 1.4 2002/10/09 20:56:09 brbarret Exp $
 *
 * Collate all the error messages from a given run.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "lamtest_error.h"


int
main(int argc, char* argv[])
{
  int i;
  char *env;
  char *collated_filename;
  FILE *fp = NULL;

  if (argc < 2) {
    fprintf(stderr, "Usage: %s <description> <error_message>\n", argv[0]);
    exit(1);
  }

  env = getenv("LAM_MPI_TEST_FILEID");
  if (env != NULL) {
    collated_filename = malloc(strlen(env) + 32);
    if (collated_filename == NULL) {
      fprintf(stderr, "report_error: Could not allocate memory\n");
      abort();
    }
    sprintf(collated_filename, "../%s", env);

    /* Open up the collated file to write to */

    fp = fopen(collated_filename, "a");

    /* Send the contents of our file (if we have one) to rank 0 */

    if (fp != NULL) {
      int len = 0;
      char *str;
      for (i = 2; i < argc; ++i)
	len += strlen(argv[i]) + 1;
      str = (char*) malloc(len + 32);
      if (str == NULL) {
	fprintf(stderr, "report_error: Could not allocate memory\n");
	abort();
      }
      for (i = 2; i < argc; ++i) {
	strcat(str, argv[i]);
	strcat(str, " ");
      }

      nonmpi_error(argv[1], str);
      free(str);
      fclose(fp);
    }

    free(collated_filename);
  }

  return 0;
}
