/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: lamtest_progress.c,v 1.2 2003/04/14 14:45:11 jsquyres Exp $
 *
 * Simple routines to print and store errors for the LAM test suite
 */

#include <stdio.h>

#include <mpi.h>

#include "lamtest_error.h"


/*
 * Local variables
 */
static char prefix[] = "Progress: [";
static char suffix[] = "]";
static char fill_char = '=';
static int width = 76 - sizeof(prefix) - sizeof(suffix);
static int rank = -1;
static int max = -1;


/*
 * Local functions
 */
static void fill(char c, int len);


void
lamtest_progress_start(int arg_max)
{
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  if (rank != 0)
    return;

  max = arg_max;
  printf("%s", prefix);
  fill(' ', width);
  printf("%s", suffix);
  fflush(stdout);
}


void
lamtest_progress(int current)
{
  float percent;
  int num_done;

  if (rank != 0)
    return;

  if (current >= max) {
    num_done = width;
  }  else if (current <= 0) {
    num_done = 0;
  } else {
    percent = ((float) current / max);
    num_done = (int) (percent * width);
  }

  printf("\r%s", prefix);
  fill(fill_char, num_done);
  fill(' ', width - num_done);
  printf("%s", suffix);
  fflush(stdout);
}


void
lamtest_progress_end(void)
{
  if (rank != 0)
    return;

  printf("\r%s", prefix);
  fill(fill_char, width);
  printf("%s\n", suffix);
  fflush(stdout);
}


static void 
fill(char c, int len)
{
  int i;

  for (i = 0; i < len; ++i)
    putchar(c);
}
