/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: lamtest_error_nonmpi.c,v 1.1 2003/06/02 20:47:21 brbarret Exp $
 *
 * Simple routines to print and store errors for the LAM test suite
 *
 *
 * This is slightly more complicated than needed because of linking
 * semantics.  The reporter and report_error applications don't call
 * MPI_INIT, so they don't bring in all the constants defined in
 * laminit.c, which can cause linking failures.
 *
 * This file contains no MPI functions, so you can call any function
 * in here without calling MPI_Init in your application.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "lamtest_error.h"


/*
 * Local variables
 */

char *separator = "<--------------------------------------------------------------------------->";

void
write_error_int(lamtest_exit_func efunc, const char *file, int line, 
		const char *rank, const char *format, ...)
{
  FILE *fp;
  char *filename;
  va_list ap;
  char *env;

  /* Try to output this to the error log file */

  env = getenv("LAM_MPI_TEST_FILEID");
  if (env != NULL) {
    if (rank != NULL) {
      filename = malloc(strlen(env) + strlen(rank) + 32);
      if (filename == NULL) {
	fprintf(stderr, "ERROR: lamtest_error::write_error() could not allocate memory\n");
	efunc((1 << 17) + 1);
	abort();
      }
      sprintf(filename, "../%s.%s", env, rank);
    } else {
      filename = malloc(strlen(env) + 32);
      if (filename == NULL) {
	fprintf(stderr, "ERROR: lamtest_error::write_error() could not allocate memory\n");
	efunc((1 << 17) + 1);
	abort();
      }
      sprintf(filename, "../%s", env);
    }
    fp = fopen(filename, "a");

    if (rank != NULL)
      fprintf(fp, "%s:", rank);
    else
      fprintf(fp, "(no rank):");

    if (file != NULL)
      fprintf(fp, "%s:", file);
    if (line != -1)
      fprintf(fp, "%d", line);
    fprintf(fp, "\n");

    va_start(ap, format);
    vfprintf(fp, format, ap);
    va_end(ap);
    fprintf(fp, "\n%s\n", separator);
    fclose(fp);

    free(filename);
  }
}


void
nonmpi_error(const char *desc, char *format, ...)
{
  va_list ap;

  /* Write the error to the file */

  va_start(ap, format);
  write_error_int(exit, desc, 0, NULL, format, ap);
  va_end(ap);
  abort();
}

