/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: lamtest_error.h,v 1.14 2003/06/02 20:47:21 brbarret Exp $
 *
 * Simple routines to print and store errors for the LAM test suite
 */

#ifndef _lamtest_error_h_
#define _lamtest_error_h_

#include <lamtest_config.h>


/*
 * Function prototypes
 */

#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {
#endif

  /*
   * Use only after MPI_Init()
   */
  int lamtest_warning(const char *file, int line, const char *format, ...);
  void lamtest_error(const char *file, int line, const char *format, ...);

  void lamtest_check_size(const char *file, int line, int min, int want_abort);
  void lamtest_need_even(const char *file, int line);

  void lamtest_progress_start(int max);
  void lamtest_progress(int current);
  void lamtest_progress_end(void);

#if LAMTEST_HAVE_MPI_F77
  void F77_FUNC_(lamtest_error_f, LAMTEST_ERROR_F)(char *msg_f, int len);
  void F77_FUNC_(lamtest_check_size_f, LAMTEST_CHECK_SIZE_F)(int* min, 
                                                             int* want_abort);
#endif

  /*
   * Safe anywhere
   */
  typedef void (lamtest_exit_func)(int);
  void write_error_int(lamtest_exit_func, const char *file, int line, 
		       const char *rank, const char *format, ...);
  void nonmpi_error(const char *desc, char *format, ...);

#if defined(c_plusplus) || defined(__cplusplus)
}
#endif

#endif
