/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: collector.c,v 1.4 2002/10/09 20:56:09 brbarret Exp $
 *
 * Collate all the error messages from a given run.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "mpi.h"


int
main(int argc, char* argv[])
{
  char *env;
  int i, size, rank;
  char *rank_filename, *collated_filename;
  FILE *fp, *collated_fp = NULL;
  char *text;
  int message, tag = 222;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  env = getenv("LAM_MPI_TEST_FILEID");
  if (env != NULL) {
    rank_filename = malloc(strlen(env) + 32);
    collated_filename = malloc(strlen(env) + 32);
    if (rank_filename == NULL || collated_filename == NULL) {
      printf("Doh!  Not able to allocate enough memory...\n");
      MPI_Abort(MPI_COMM_WORLD, (1 << 16) + 1);
    }
    sprintf(rank_filename, "../%s.%d", env, rank);
    sprintf(collated_filename, "../%s", env);
    fp = fopen(rank_filename, "r");

    /* If we're rank 0, open up the collated file to write to */

    if (rank == 0)
      collated_fp = fopen(collated_filename, "a");

    /* Send the contents of our file (if we have one) to rank 0 */

    if (fp == NULL) {
      if (rank != 0) {
	message = 0;
	MPI_Send(&message, 1, MPI_INT, 0, tag, MPI_COMM_WORLD);
      } 
    } else {
      fseek(fp, 0, SEEK_END);
      message = (int) ftell(fp);
      fseek(fp, 0, SEEK_SET);
      text = malloc(message);
      if (text == NULL) {
	printf("Doh!  Not able to allocate enough memory...\n");
	MPI_Abort(MPI_COMM_WORLD, (1 << 16) + 1);
      }
      fread(text, message, 1, fp);

      /* Rank 0 can write directly to the collated file; everyone else
         does an MPI_Send */

      if (rank == 0)
	fwrite(text, message, 1, collated_fp);
      else
	MPI_Send(&message, 1, MPI_INT, 0, tag, MPI_COMM_WORLD);
	MPI_Send(text, message, MPI_CHAR, 0, tag + 1, MPI_COMM_WORLD);
      free(text);
      fclose(fp);
    }

    /* If we're rank 0, receive from everyone else */

    if (rank == 0) {
      for (i = 1; i < size; i++) {
	MPI_Recv(&message, 1, MPI_INT, i, tag, MPI_COMM_WORLD, 
		 MPI_STATUS_IGNORE);
	if (message > 0) {
	  text = malloc(message);
	  if (text == NULL) {
	    printf("Doh!  Not able to allocate enough memory...\n");
	    MPI_Abort(MPI_COMM_WORLD, (1 << 16) + 1);
	  }
	  MPI_Recv(text, message, MPI_CHAR, i, tag + 1, MPI_COMM_WORLD,
		   MPI_STATUS_IGNORE);
	  fwrite(text, message, 1, collated_fp);
	  free(text);
	}
      }
    }

    if (collated_fp != NULL)
      fclose(collated_fp);
    unlink(rank_filename);
    free(rank_filename);
    free(collated_filename);
  }

  MPI_Finalize();
  return 0;
}
