/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: testany.c,v 1.10 2002/10/09 20:56:04 brbarret Exp $
 */
/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************
*/
#include <stdio.h>
#include "mpi.h"

#include "lamtest_error.h"

int
main(int argc, char **argv)
{
  int me, tasks, i, data[2000], index, flag, done;
  MPI_Request req[2000];
  MPI_Status status;

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &me);
  MPI_Comm_size(MPI_COMM_WORLD, &tasks);

  lamtest_check_size(__FILE__, __LINE__, 2, 1);

  if (me)
    MPI_Send(&me, 1, MPI_INT, 0, 1, MPI_COMM_WORLD);
  else {
    req[0] = MPI_REQUEST_NULL;
    for (i = 1; i < tasks; i++)
      MPI_Irecv(&data[i - 1], 1, MPI_INT, i, 1, MPI_COMM_WORLD,
		&req[i - 1]);

    MPI_Testany(0, req, &index, &flag, &status);
    if (!flag)
      lamtest_error(__FILE__, __LINE__, "ERROR in MPI_Testany: flag is not set (1)\n");
    if (index != MPI_UNDEFINED)
      lamtest_error(__FILE__, __LINE__, "ERROR in MPI_Testany: index not = MPI_UNDEFINED (1)\n");

    done = 0;
    while (done < tasks - 1) {
      MPI_Testany(tasks - 1, req, &index, &flag, &status);
      if (flag) {
	if (index == MPI_UNDEFINED)
	  lamtest_error(__FILE__, __LINE__, "ERROR in MPI_Testany: index = MPI_UNDEFINED (done = %d)\n",
			done);
	else if (req[index] != MPI_REQUEST_NULL)
	  lamtest_error(__FILE__, __LINE__, "ERROR in MPI_Testany: request not set to NULL (done = %d)\n",
			done);
	else if (data[index] != index + 1)
	  lamtest_error(__FILE__, __LINE__, "ERROR in MPI_Testany: wrong data -- %d != %d (index = %d, done = %d)\n",
			data[index], index + 1, index, done);
	done++;
      }
    }

    MPI_Testany(tasks - 1, req, &index, &flag, &status);
    if (!flag)
      lamtest_error(__FILE__, __LINE__, "ERROR in MPI_Testany: flag is not set (2)\n");
    if (index != MPI_UNDEFINED)
      lamtest_error(__FILE__, __LINE__, "ERROR in MPI_Waitany: index not = MPI_UNDEFINED (2)\n");
  }
  MPI_Barrier(MPI_COMM_WORLD);
  MPI_Finalize();
  return 0;
}
