/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 *	$Id: ssend.c,v 1.6 2002/10/09 20:56:03 brbarret Exp $
 *
 *	Function:	- tests synchonicity of MPI_Ssend between two ranks
 */

#include <stdio.h>
#include <unistd.h>
#include <mpi.h>

#include "lamtest_error.h"

#define WAIT_SECONDS	10	       /* # seconds wait-time */


int
main(int argc, char **argv)
{
  MPI_Status stat;
  int rank;
  int flag, junk;
  double time;

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  lamtest_check_size(__FILE__, __LINE__, 2, 1);
 
  if (rank == 0) {
    MPI_Recv(&junk, 1, MPI_INT, 1, 0, MPI_COMM_WORLD, &stat);
    MPI_Ssend(&rank, 1, MPI_INT, 1, 1, MPI_COMM_WORLD);
    MPI_Send(&rank, 1, MPI_INT, 1, 2, MPI_COMM_WORLD);
  } else if (rank == 1) {
    MPI_Send(&rank, 1, MPI_INT, 0, 0, MPI_COMM_WORLD);

    time = MPI_Wtime();
    do {
      MPI_Iprobe(0, 2, MPI_COMM_WORLD, &flag, &stat);
      if (flag)
	break;
      sleep(1);
    } while ((MPI_Wtime() - time) < WAIT_SECONDS);

    MPI_Recv(&junk, 1, MPI_INT, 0, 1, MPI_COMM_WORLD, &stat);
    MPI_Recv(&junk, 1, MPI_INT, 0, 2, MPI_COMM_WORLD, &stat);

    if (flag) {
      lamtest_error(__FILE__, __LINE__, "MPI_Ssend did not synchronize: "
		    "tag 2 received before tag 1\n");
    }
  }

  MPI_Barrier(MPI_COMM_WORLD);
  MPI_Finalize();
  return (0);
}
