c
c Copyright (c) 2001-2003 The Trustees of Indiana University.  
c                         All rights reserved.
c Copyright (c) 1998-2001 University of Notre Dame. 
c                         All rights reserved.
c Copyright (c) 1994-1998 The Ohio State University.  
c                         All rights reserved.
c 
c This file is part of the LAM/MPI software package.  For license
c information, see the LICENSE file in the top level directory of the
c LAM/MPI source distribution.
c 
c $HEADER$
c
c $Id: sendrecv_f.f,v 1.4 2003/06/01 16:42:24 jsquyres Exp $
c
c****************************************************************************
c
c MESSAGE PASSING INTERFACE TEST CASE SUITE
c
c Copyright IBM Corp. 1995
c
c       IBM Corp. hereby grants a non-exclusive license to use, copy,
c       modify, and distribute this software for any purpose and without
c       fee provided that the above copyright notice and the following
c       paragraphs appear in all copies.
c
c       IBM Corp. makes no representation that the test cases comprising
c       this suite are correct or are an accurate representation of any
c       standard.
c
c       In no event shall IBM be liable to any party for direct,
c       indirect, special incidental, or consequential damage arising
c       out of the use of this software even if IBM Corp. has been
c       advised of the possibility of such damage.
c
c       IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT
c       NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
c       FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED
c       HEREUNDER IS ON AN "AS IS" BASIS AND IBM CORP. HAS NO OBLIGATION
c       TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
c       MODIFICATIONS.
c
c****************************************************************************
c
c       These test cases reflect an interpretation of the MPI Standard.
c       They are are, in most cases, unit tests of specific MPI
c       behaviors.  If a user of any test case from this set believes
c       that the MPI Standard requires behavior different than that
c       implied by the test case we would appreciate feedback.
c
c Comments may be sent to:
c    Richard Treumann
c    treumann@kgn.ibm.com
c
c****************************************************************************
c
c	Transmit a message in a two process system.
c
	program sendrecv

        include 'mpif.h'

	integer*4 BUFSIZE

	parameter (BUFSIZE = 100)

	integer		rank
	integer		size
	integer 	status(MPI_STATUS_SIZE)
	integer         src
	integer         dest
        integer         sendtag
        integer         recvtag
        integer*4       sendbuf(BUFSIZE)
	integer*4       recvbuf(BUFSIZE)
	integer         st_source, st_tag
	integer         min
	integer         want_abort

c
c Initialize MPI.
c
	call MPI_INIT(ierror)
c
c Error check the number of processes.
c Determine my rank in the world group.
c The sender will be rank 0 and the receiver, rank 1.
c
	call MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)
        call MPI_COMM_RANK(MPI_COMM_WORLD, rank, ierror)

	min = 2
	want_abort = 1

	call lamtest_check_size_f(min, want_abort)
c
c As rank 0, send a message to rank 1.
c
	if (rank .lt. 2) then
	   src = 1 - rank
	   dest = 1 - rank
	   sendtag = rank
	   recvtag = src

	   do i = 1, 100
	      sendbuf(i) = rank
	      recvbuf(i) = -1
	   end do
	   
	   call MPI_SENDRECV(sendbuf(1), 100, MPI_INTEGER, dest,
     +                       sendtag, recvbuf(1), 100,
     +                       MPI_INTEGER, src, recvtag,
     +                       MPI_COMM_WORLD, status, ierror)

	   do i = 1, 100
	      if (recvbuf(i) .ne. src) then
		 call lamtest_error_f('MPI_Sendrecv error(1)')
		 go to 121
	      endif             
 121	   end do	 

	   st_source = status(MPI_SOURCE)
           st_tag = status(MPI_TAG)
      	   
	   if (st_source .ne. src) then
	      call lamtest_error_f('MPI_Sendrecv error(2)')
	   endif

	   if (st_tag .ne. recvtag) then
	      call lamtest_error_f('MPI_Sendrecv error(3)')
	   endif
 	endif
	      
	if (rank .eq. 0) then
	   src = size - 1
	else
	   src = rank - 1
	endif

	if (rank .eq. size - 1) then
	   dest = 0
	else
	   dest = rank + 1
	endif

	sendtag = rank
	recvtag = src

	do i = 1, 100
           sendbuf(i) = rank
           recvbuf(i) = -1
        end do

        call MPI_SENDRECV(sendbuf(1), 100, MPI_INTEGER, dest,
     +                    sendtag, recvbuf(1), 100,
     +                    MPI_INTEGER, src, recvtag,
     +                    MPI_COMM_WORLD, status, ierror)

        do i = 1, 100
           if(recvbuf(i) .ne. src) then
	      call lamtest_error_f('MPI_Sendrecv error(4)')
	      go to 165
	   endif
 165	end do

	st_source = status(MPI_SOURCE)
        st_tag = status(MPI_TAG)

        if (st_source .ne. src) then
	   call lamtest_error_f('MPI_Sendrecv error(5)')
        endif

        if (st_tag .ne. recvtag) then
	   call lamtest_error_f('MPI_Sendrecv error(6)')
        endif

	call MPI_FINALIZE(ierror)
	stop
	end




