/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: bsend_free.c,v 1.14 2003/05/07 22:36:34 jsquyres Exp $
 */
/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************
*/
#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"

#include "lamtest_error.h"

#define ITER 2 
#define SIZE 1000000
#define SMALL 2000

int 
main(int argc, char **argv)
{
   int i,me,*datain,*dataout;
   int *buf;
   MPI_Status status;
   MPI_Request request;
   MPI_Comm comm;
   int pair_lo, pair_hi;

   MPI_Init(&argc,&argv);
   comm = MPI_COMM_WORLD;
   MPI_Comm_rank(comm,&me);

   lamtest_check_size(__FILE__, __LINE__, 2, 1);
   lamtest_need_even(__FILE__, __LINE__);

   pair_lo = (me / 2) * 2;
   pair_hi = ((me / 2) * 2) + 1;

   /* Add this section because some os/architectures can't allocate
      this much memory on the stack */

   datain = malloc(sizeof(int) * SMALL);
   dataout = malloc(sizeof(int) * SMALL);
   buf = malloc(sizeof(int) * SIZE);
   if (datain == NULL || dataout == NULL || buf == NULL)
     lamtest_error(__FILE__, __LINE__, "Doh!  Rank %d was not able to allocate enough memory.  MPI test aborted!\n");

   /* Clear the buffer to prevent unitialized reads */

   for (i = 0; i < SMALL; i++)
     dataout[i] = i;

   MPI_Buffer_attach(buf, sizeof(int) * SIZE);
   if (me == pair_lo)  {
      for(i=0;i<ITER;i++)  {
         dataout[i] = i;
         MPI_Ibsend(&dataout[i],SMALL - 10, MPI_INT,
		    pair_hi, 0, comm, &request);
         MPI_Request_free(&request); 
      }
      MPI_Barrier(comm);
   } else if (me == pair_hi) {
      MPI_Barrier(comm);
      for(i=0;i<ITER;i++)  {
         MPI_Recv(datain,SMALL - 10, MPI_INT, pair_lo,
		  0, comm, &status);
         if (datain[0] != i)
	   lamtest_error(__FILE__, __LINE__, "ERROR %d %d\n",i,datain[0]);
      }
   }
   MPI_Barrier(comm);
   MPI_Finalize();

   /* Clean up, 'cause it's the Right Thing to do */

   free(datain);
   free(dataout);
   free(buf);

   return 0;
}
