/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: bsend.c,v 1.13 2002/10/09 20:56:03 brbarret Exp $
 */
/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mpi.h"
#include "lamtest_error.h"

#define BIGSIZE 100000
#define SMALLSIZE 1000

int 
main(int argc, char**argv)
{
   int *oldbuf,me,i,size;
   int *data, *buf1, *buf2;
   int sizeof_data, sizeof_buf1, sizeof_buf2;
   int pair_lo, pair_hi;
   MPI_Status status;
 
   MPI_Init(&argc,&argv);
   MPI_Comm_rank(MPI_COMM_WORLD,&me);

   lamtest_check_size(__FILE__, __LINE__, 2, 1);
   lamtest_need_even(__FILE__, __LINE__);

   sizeof_data = (BIGSIZE * sizeof(int) + MPI_BSEND_OVERHEAD);
   data = malloc(sizeof_data);
   sizeof_buf1 = (SMALLSIZE * sizeof(int) + MPI_BSEND_OVERHEAD);
   buf1 = malloc(sizeof_buf1);
   sizeof_buf2 = (2 * BIGSIZE * sizeof(int) + MPI_BSEND_OVERHEAD);
   buf2 = malloc(sizeof_buf2);
   if (data == NULL || buf1 == NULL || buf2 == NULL)
     lamtest_error(__FILE__, __LINE__, "Doh!  Rank %d was not able to allocate enough memory.  MPI test aborted!\n", me);

   pair_lo = (me / 2) * 2;
   pair_hi = ((me / 2) * 2) + 1;

   if (me == pair_lo) {

     /* First test */

      MPI_Buffer_attach(buf1, sizeof_buf1);
      memset(data, 0, sizeof(int) * BIGSIZE);
      MPI_Bsend(data, SMALLSIZE, MPI_INT, pair_hi, 1, MPI_COMM_WORLD);
      MPI_Buffer_detach(&oldbuf,&size);
      if (oldbuf != buf1)
         lamtest_error(__FILE__, __LINE__, 
		       "ERROR in MPI_Buffer_detach, wrong buffer returned\n");
      if (size != sizeof_buf1)
         lamtest_error(__FILE__, __LINE__, 
		       "ERROR in MPI_Buffer_detach, wrong size returned\n");
 
      MPI_Buffer_attach(buf2, sizeof_buf2);
      MPI_Bsend(data, SMALLSIZE + 1, MPI_INT, pair_hi, 1, MPI_COMM_WORLD);

      /* End of first test */
 
      MPI_Barrier(MPI_COMM_WORLD);

      /* Second test */ 
      /* test to see if large array is REALLY being buffered */

      for (i = 0; i < BIGSIZE; ++i)
	data[i] = 1;
      MPI_Bsend(data, BIGSIZE, MPI_INT, pair_hi, 1, MPI_COMM_WORLD);
      MPI_Recv(data, BIGSIZE, MPI_INT, pair_hi, 2, MPI_COMM_WORLD, &status);
      for (i = 0; i < BIGSIZE; i++)
         if (data[i] != 2)  
	   lamtest_error(__FILE__, __LINE__, 
			 "ERROR, incorrect data value, task 0\n");
      MPI_Buffer_detach(&oldbuf,&size);
   } else if (me == pair_hi) {
      MPI_Recv(data, SMALLSIZE, MPI_INT, pair_lo, 1, MPI_COMM_WORLD, &status);
      MPI_Recv(data, SMALLSIZE + 1, MPI_INT, pair_lo, 1, MPI_COMM_WORLD, 
	       &status);
 
      MPI_Barrier(MPI_COMM_WORLD);

      /* Second test */
      /* test to see if large array is REALLY being buffered */

      MPI_Buffer_attach(buf2, sizeof_buf2);
      for (i = 0; i < BIGSIZE; ++i)
	data[i] = 2;
      MPI_Bsend(data, BIGSIZE, MPI_INT, pair_lo, 2, MPI_COMM_WORLD);
      MPI_Recv(data, BIGSIZE, MPI_INT, pair_lo, 1, MPI_COMM_WORLD, &status);
      for (i = 0; i < BIGSIZE; i++)
         if (data[i] != 1)  
	   lamtest_error(__FILE__, __LINE__, "ERROR, incorrect data value, task 1\n");
      MPI_Buffer_detach(&oldbuf,&size);
   }

   MPI_Barrier(MPI_COMM_WORLD);

   free(data);
   free(buf1);
   free(buf2);

   MPI_Finalize();
   return 0;
}
