/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: get.c,v 1.8 2002/10/09 20:56:01 brbarret Exp $
 *
 * Basic get/put test.  Mainly contributed by some LAM user(sorry;
 * I've long since lost the name of the original author!).  Somewhat
 * modified to be suitable for the LAM test suite.  
 */

#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

#include "lamtest_error.h"

int 
main(int argc, char *argv[])
{
  int i, size, rank;
  int *winArea, *rcvArea;
  MPI_Win win;

  MPI_Init(&argc, &argv);

  /*  Enough processes? */

  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  /* Make window */

  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
  MPI_Alloc_mem(sizeof(int) * size, MPI_INFO_NULL, &rcvArea);
  MPI_Win_create(winArea, sizeof(int), sizeof(int), MPI_INFO_NULL, 
		 MPI_COMM_WORLD, &win);

  /* Have every assign their "get" area to be their rank value */

  *winArea = rank;
  MPI_Win_fence(0, win);

  /* Have everyone get from everyone else */

  for (i = 0; i < size; ++i) {
    rcvArea[i] = -1;
    MPI_Get(&rcvArea[i], 1, MPI_INT, i, 0, 1, MPI_INT, win);
  }
  MPI_Win_fence(0, win);

  /* Check to see that we got the right value */

  for (i = 0; i < size; ++i) 
    if (rcvArea[i] != i)
      lamtest_error(__FILE__, __LINE__, 
		    "Rank %d got rcvArea[%d] = %d when expecting %d\n",
		    rank, i, rcvArea[i], i);

  MPI_Win_free(&win);  
  MPI_Free_mem(winArea);
  MPI_Free_mem(rcvArea);
  MPI_Finalize();
  return(0);
}
