/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame.
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.
 *                         All rights reserved.
 *
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: alloc_cxx.cc,v 1.1 2003/04/25 00:57:46 adharurk Exp $
 *
 * tests MPI::Alloc_mem and MPI::Free_mem
 */

#include "mpi.h"
#include "lamtest_error.h"

int
main(int argc, char** argv)
{
  int i, size, rank;
  int *rcvArea;
  MPI::Intracomm intra;
  MPI::Init(argc, argv);
  intra = MPI::COMM_WORLD;
  size = intra.Get_size();
  rank = intra.Get_rank();
  
  rcvArea = (int *) MPI::Alloc_mem(sizeof(int) * size, MPI_INFO_NULL);

  for (i = 0; i < size; i++) {
    rcvArea[i] = i;
  }
  for (i = 0; i < size; i++) {
    if (rcvArea[i] != i) {
      lamtest_error(__FILE__, __LINE__,
                    "Rank %d got rcvArea[%d] = %d when expecting %d\n",
                    rank, i, rcvArea[i], i);
    }
  }

  MPI::Free_mem(rcvArea);
  MPI::Finalize();
  return(0);
}
