/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: accumulate.c,v 1.6 2002/10/09 20:56:01 brbarret Exp $
 *
 * Basic fence test.  Mainly contributed by some LAM user(sorry; I've
 * long since lost the name of the original author!).  Somewhat
 * modified to be suitable for the LAM test suite.
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"

int 
main(int argc, char *argv[])
{
  int SendBuff, RecvBuff, rank, size, expected, i;
  int MPI_MODE_NOPUT = 0,
      MPI_MODE_NOSUCCEED = 0,
      MPI_MODE_NOPRECEDE = 0;
  MPI_Win Win;
  MPI_Aint sizeOfInt;

  MPI_Init(&argc, &argv);

  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);

  MPI_Type_extent(MPI_INT, &sizeOfInt);
  MPI_Win_create(&RecvBuff, sizeOfInt, 1, MPI_INFO_NULL,
		  MPI_COMM_WORLD, &Win);

  SendBuff = rank + 100;
  RecvBuff = 0;

  /* Accumulate to everyone, just for the heck of it */

  MPI_Win_fence(MPI_MODE_NOPRECEDE, Win);
  for (i = 0; i < size; ++i)
    MPI_Accumulate(&SendBuff, 1, MPI_INT, i, 0, 1, MPI_INT, MPI_SUM, Win);
  MPI_Win_fence((MPI_MODE_NOPUT | MPI_MODE_NOSUCCEED), Win);

  for (expected = i = 0; i < size; i++)
    expected += (i + 100);
  if (RecvBuff != expected)
    lamtest_error(__FILE__, __LINE__, 
		  "Rank %d got %d when it expected %d\n",
		  rank, RecvBuff, expected);

  MPI_Win_free(&Win);
  MPI_Finalize();
  return 0;
}
