/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 70_get_attr_cxx.cc,v 1.4 2003/06/02 02:59:46 jsquyres Exp $
 */

#include <mpi.h> 

#include "lamtest_error.h" 
  
 
int 
main(int argc, char** argv) 
{ 
  int size, rank; 
  int *winArea; 
  void *base;
  bool flag;
  MPI::Win win;
  MPI::Group group;

  MPI::Init(argc, argv); 
 
  MPI_Comm_size(MPI_COMM_WORLD, &size); 
  MPI_Comm_rank(MPI_COMM_WORLD, &rank); 
 
  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea); 
  
  win = MPI::Win::Create(winArea, sizeof(int), sizeof(int), 
                         MPI_INFO_NULL, MPI_COMM_WORLD); 
 
  *winArea = rank; 

  // Test for MPI::Win::Get_attr. Abort when no attribute associated
  // with the keyval

  flag = win.Get_attr(win, MPI_WIN_BASE, &base);
  if (!flag)
    lamtest_error(__FILE__, __LINE__, 
		  "Win::Get_attr: No attribute associated with this keyval\n");
  if (base != winArea)
    lamtest_error(__FILE__, __LINE__, 
		  "Win::Get_attr: Got wrong value for base\n");

  win.Free();
  MPI_Free_mem(winArea); 
  MPI::Finalize(); 
  return(0); 
}
