/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 60_get_name_cxx.cc,v 1.5 2003/06/27 12:56:29 jsquyres Exp $
 */

#include <string.h>
#include <mpi.h> 

#include <lamtest_error.h>
 
 
int 
main(int argc, char** argv) 
{ 
  int size, rank; 
  int *winArea; 
  MPI::Win win;
  char winname[] = "Win_Name";
  char getname[MPI_MAX_OBJECT_NAME];
  int resultlen;

  MPI::Init(argc, argv); 
 
  MPI_Comm_size(MPI_COMM_WORLD, &size); 
  MPI_Comm_rank(MPI_COMM_WORLD, &rank); 
 
  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea); 
  
  win = MPI::Win::Create(winArea, sizeof(int), sizeof(int), 
                         MPI_INFO_NULL, MPI_COMM_WORLD); 
 
  *winArea = rank; 
  
  /* 
   * Set and get window name and compare the two to see if the value is same
   * as we put in. Else abort.
   */  

  win.Set_name(winname);
  win.Get_name(getname, resultlen);
  if (strcmp(winname, getname) != 0)
      lamtest_error(__FILE__, __LINE__,
		    "Win::Get_name obtained value \"%s\", expected \"%s\"\n",
		    getname, winname);

  win.Free();
  MPI_Free_mem(winArea); 
  MPI::Finalize(); 
  return(0); 
}
