/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 50_get_group_cxx.cc,v 1.3 2003/06/02 02:25:35 jsquyres Exp $
 */

#include <mpi.h> 
 
 
int 
main(int argc, char** argv) 
{ 
  int size, rank; 
  int *winArea; 
  MPI::Win win;
  MPI::Group group;

  MPI::Init(argc, argv); 
 
  MPI_Comm_size(MPI_COMM_WORLD, &size); 
  MPI_Comm_rank(MPI_COMM_WORLD, &rank); 
 
  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea); 

  /* 
   * Simple test case to test MPI::Win::Get_group
   */
  
  win = MPI::Win::Create(winArea, sizeof(int), sizeof(int), 
                         MPI_INFO_NULL, MPI_COMM_WORLD); 
 
  *winArea = rank; 
  
  group = win.Get_group();

  win.Free();
  MPI_Free_mem(winArea); 
  MPI::Finalize(); 
  return(0); 
}
