/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 *      $Id: 40_put_cxx.cc,v 1.1 2003/02/16 21:20:12 vsahay Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

#include "lamtest_error.h"


int 
main(int argc, char *argv[])
{
  int i, size, rank;
  int *winArea, *putvals;
  MPI::Win win;

  MPI::Init(argc, argv);

  /*  Enough processes? */

  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  /* Make window */

  MPI_Alloc_mem(sizeof(int) * size, MPI_INFO_NULL, &winArea);
  MPI_Alloc_mem(sizeof(int) * size, MPI_INFO_NULL, &putvals);
  win = MPI::Win::Create(winArea, sizeof(int) * size, sizeof(int),
			 MPI_INFO_NULL, MPI_COMM_WORLD);

  /* Set all the target areas to be -1 */

  for (i = 0; i < size; ++i) {
    winArea[i] = -1;
    putvals[i] = rank;
  }
  win.Fence(0);

  /* Do a put to all other processes */

  for (i = 0; i < size; ++i)
    win.Put(&putvals[i], 1, MPI_INT, i, rank, 1, MPI_INT);

  win.Fence(0);

  /* Check to see that we got the right values */

  for (i = 0; i < size; ++i)
    if (winArea[i] != i)
      lamtest_error(__FILE__, __LINE__, 
		    "Rank %d got winArea[%d]=%d when expecting %d\n",
		    rank, i, winArea[i], i);

  win.Free();  
  MPI_Free_mem(winArea);
  MPI_Free_mem(putvals);
  MPI::Finalize();
  return(0);
}
