/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 30_get_cxx.cc,v 1.2 2003/05/04 14:00:17 jsquyres Exp $
 */

#include <mpi.h>

#include "lamtest_error.h"


int
main(int argc, char** argv)
{
  int i, size, rank;
  int *winArea, *rcvArea;
  MPI::Info info;
  MPI::Win win;

  MPI::Init(argc, argv);

  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
  MPI_Alloc_mem(sizeof(int) * size, MPI_INFO_NULL, &rcvArea);
  win = MPI::Win::Create(winArea, sizeof(int), sizeof(int),
                         MPI_INFO_NULL, MPI_COMM_WORLD);

  *winArea = rank;
  win.Fence(0);

  for (i = 0; i < size; ++i) {
    rcvArea[i] = -1;
    MPI_Get(&rcvArea[i], 1, MPI_INT, i, 0, 1, MPI_INT, win);
  }
  win.Fence(0);

  for (i = 0; i < size; ++i)
    if (rcvArea[i] != i)
      lamtest_error(__FILE__, __LINE__,
                    "Rank %d got rcvArea[%d]=%d when expecting %d\n",
                    rank, i, rcvArea[i], i);

  win.Free();

  MPI_Free_mem(winArea);
  MPI_Free_mem(rcvArea);
  MPI::Finalize();
  return(0);
}
