/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 *      $Id: 20_free_cxx.cc,v 1.2 2003/06/02 02:25:35 jsquyres Exp $
 */

#include <iostream>
#include <mpi.h>

using namespace std;

int
main(int argc, char** argv)
{
  int *winArea;

  MPI::Init(argc, argv);

  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);

  /* 
   * Pretty simple test -- just test MPI::Win::Free
   */

  MPI::Win win = MPI::Win::Create(winArea, sizeof(int), sizeof(int),
                         MPI_INFO_NULL, MPI_COMM_WORLD);

  win.Free();

  MPI_Free_mem(winArea);
  MPI::Finalize();
  return 0;
}
