/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 *      $Id: 11_lock_cxx.cc,v 1.1 2003/02/16 21:20:12 vsahay Exp $
 */

#include <iostream>
#include <mpi.h>

using namespace std;

int
main(int argc, char** argv)
{
  int i, size, rank;
  int *winArea, *rcvArea;
  MPI::Info info;
  MPI::Win win;
  MPI::Init(argc, argv);
  
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
   
  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
  MPI_Alloc_mem(sizeof(int) * size, MPI_INFO_NULL, &rcvArea);

  win = MPI::Win::Create(winArea, sizeof(int), sizeof(int),
			 MPI_INFO_NULL, MPI_COMM_WORLD);

  win.Lock(0, 0, 0);

  MPI_Free_mem(winArea);
  MPI_Free_mem(rcvArea);

  MPI::Finalize();
  return(0);
}
