/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 10_fence_cxx.cc,v 1.3 2003/05/04 14:04:43 jsquyres Exp $
 */

#include <iostream>
#include <mpi.h>

using namespace std;

int
main(int argc, char** argv)
{
  int *winArea;
  MPI::Win win;
  MPI::Init(argc, argv);

  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);

  /* 
   * Just test MPI::Win::Fence
   */

  win = MPI::Win::Create(winArea, sizeof(int), sizeof(int),
                         MPI_INFO_NULL, MPI_COMM_WORLD);

  *winArea = 2;
  win.Fence(0);

  win.Free();
  MPI_Free_mem(winArea);

  MPI::Finalize();
  return(0);
}
