/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: env_vars.c,v 1.4 2003/05/07 22:37:46 jsquyres Exp $
 *
 * Test LAM's ability to export environment variables to remote ranks
 */

#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

#include "lamtest_error.h"


int 
main(int argc, char **argv)
{
  int rank, size;
  char *s;

  /* Start up MPI */

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
 
  s = getenv("TEST");
  if (s == NULL)
    lamtest_error(__FILE__, __LINE__, "ERROR: Got null value for environment variable TEST :-(\n");
  s = getenv("LAM_MPI_TEST");
  if (s == NULL)
    lamtest_error(__FILE__, __LINE__, "ERROR: Got null value for environment variable LAM_MPI_TEST :-(\n");

  /* Quit */

  MPI_Finalize();
  return 0;
}
