/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: attrs.c,v 1.2 2003/04/14 14:43:45 jsquyres Exp $
 *
 * Test whether several MPI attributes are set correctly on
 * MPI_COMM_WORLD.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

#include "lamtest_error.h"

/* This program is only built if we have the Trillium header files --
   we need them for this test */

#include <mpisys.h>


int
get_attr(char* str, int key, int *val)
{
  void **attrp;
  int flag = 0;

  MPI_Comm_get_attr(MPI_COMM_WORLD, key, &attrp, &flag);
  if (flag != 1) {
    lamtest_error(__FILE__, __LINE__, "ERROR: Didn't get attribute %s\n", str);
    return 1;
  }
  if (val != NULL)
    *val = (int) *attrp;

  return 0;
}


int
main(int argc, char* argv[])
{
  int val, i, ret = 0;
  int *nodes, nnodes, lam_universe_size;
  struct route r;

  MPI_Init(&argc, &argv);

  /* Find out what the values *should* be */

  nnodes = getntype(0, NT_CAST);
  nodes = malloc(sizeof(int) * nnodes);
  if (nodes == NULL)
    return -1;
  
  getnodes(nodes, nnodes, 0, NT_CAST);
  for (lam_universe_size = i = 0; i < nnodes; i++) {
    r.r_nodeid = nodes[i];
    getrent(&r);
    lam_universe_size += r.r_ncpus;
  }
  free(nodes);

  /* Get the predefined attributes, compare them to the known
     values */

  ret += get_attr("MPI_UNIVERSE_SIZE", MPI_UNIVERSE_SIZE, &val);
  if (val != lam_universe_size) {
    lamtest_error(__FILE__, __LINE__, 
                  "ERROR: MPI_UNIVERSE_SIZE attribute has wrong value: has %d, should be %d\n",
                  val, lam_universe_size);
  }
  ret += get_attr("LAM_UNIVERSE_NCPUS", LAM_UNIVERSE_NCPUS, &val);
  if (val != lam_universe_size) {
    lamtest_error(__FILE__, __LINE__, 
                  "ERROR: LAM_UNIVERSE_NCPUS attribute has wrong value: has %d, should be %d\n",
                  val, lam_universe_size);
  }
  ret += get_attr("LAM_UNIVERSE_NNODES", LAM_UNIVERSE_NNODES, &val);
  if (val != nnodes) {
    lamtest_error(__FILE__, __LINE__, 
                  "ERROR: LAM_UNIVERSE_NNODES attribute has wrong value: has %d, should be %d\n",
                  val, nnodes);
  }

  /* Just ensure that these exist; don't check the values */

  ret += get_attr("IMPI_CLIENT_SIZE", IMPI_CLIENT_SIZE, NULL);
  ret += get_attr("IMPI_CLIENT_COLOR", IMPI_CLIENT_COLOR, NULL);
  ret += get_attr("IMPI_HOST_SIZE", IMPI_HOST_SIZE, NULL);
  ret += get_attr("IMPI_HOST_COLOR", IMPI_HOST_COLOR, NULL);

  MPI_Finalize();
  return ret;
}
