/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: util.c,v 1.2 2002/10/09 20:55:59 brbarret Exp $
 *
 * Utility function for LAM-specific spawn tests
 */

#include "mpi.h"

#include "lamtest_spawn.h"


void
free_inter(MPI_Comm inter, int do_free)
{
  MPI_Comm intra;
  int size;

  MPI_Comm_size(inter, &size);

  MPI_Intercomm_merge(inter, 0, &intra);
  MPI_Comm_size(inter, &size);
  
  MPI_Comm_free(&intra);
  if (do_free)
    MPI_Comm_free(&inter);
}  
