/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: main.c,v 1.3 2003/06/27 02:07:36 jsquyres Exp $
 *
 * Program to test MPI_Comm_spawn with info arguments.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <mpi.h>
#include <lamtest_spawn.h>

/*
 * Exported variables
 */

char *cmd_argv1 = "this_is_argv_1";
char *cmd_argv2 = "this_is_argv_2";
const int name_tag = 201;
const int ata_tag = 202;
const int node_tag = 203;
int verbose = 0;

int 
main(int argc, char *argv[])
{
  int i, rank, size;
  MPI_Comm parent;
 
  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  /* Do we have a -v argument? */

  for (i = 0; i < argc; ++i)
    if (strcmp(argv[i], "-v") == 0)
      verbose = 1;

  /* Check to see if we *were* spawned -- because this is a test, we
     can only assume the existence of this one executable.  Hence, we
     both mpirun it and spawn it. */

  parent = MPI_COMM_NULL;
  MPI_Comm_get_parent(&parent);
  if (parent != MPI_COMM_NULL) {
    char *argv1 = 0;
    char *argv2 = 0;
    if (argc > 1)
      argv1 = argv[1];
    if (argc > 2)
      argv2 = argv[2];
    do_target(argv[0], argv1, argv2, parent);
  } else
    do_parent(argv[0], rank);

  /* All done */

  MPI_Finalize();
  return 0;
}


