/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: lamtest_spawn.h,v 1.5 2003/06/19 04:12:29 jsquyres Exp $
 *
 * Helper function for LAM-specific spawn tests
 */

#ifndef _lamtest_spawn_h_
#define _lamtest_spawn_h_ 1

#include "lamtest_config.h"

/*
 * Utility functions for LAM-specific spawn tests
 */

void all_to_all(MPI_Comm intra);
void free_inter(MPI_Comm comm, int do_free);
void find_cmd(MPI_Comm *comm, char *cmd, int need_all, int *found);

/*
 * Each spawn-test app provides these
 */

void do_parent(char *cmd, int rank);
void do_target(char *argv0, char *argv1, char *argv2,
	       MPI_Comm parent_inter);


/*
 * Global variable
 */

extern char *cmd_argv1;
extern char *cmd_argv2;
extern const int name_tag;
extern const int ata_tag;
extern const int node_tag;
extern int verbose;


/*
 * External LAM functions that are not necessarily in the installed
 * LAM/MPI header files
 */

#if LAMTEST_HAVE_TRILLIUM
#include "net.h"
#include "rreq.h"
#else

/* This is risky! */
/* Copied from <net.h> */
#define NT_CAST 0x02
#define NT_WASTE 0x04

extern int getnodeid();
extern int getntype(int, int);
extern int getnodes(int *p, int n, int tp, int msk);

/* Copied form rreq.h */
struct route {
	int		r_nodeid;	/* destination node */
	int		r_event;	/* forward to this event */
	int		r_link;		/* forward to this link # */
	int		r_event2;	/* min-route event */
	int		r_link2;	/* min-route link # */
	int		r_nodetype;	/* NT bits defined in net.h */
	int		r_ncpus;	/* number of CPUs at the end
					   of this link */
};
extern int getrent(struct route *rent);

#endif

#endif /* _lamtest_spawn_h_ */
