/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: find.c,v 1.2 2002/10/09 20:55:59 brbarret Exp $
 *
 * Helper function for LAM-specific spawn tests
 */

#include <stdio.h>
#include <stdlib.h>

#include "mpi.h"
#include "lamtest_error.h"
#include "lamtest_spawn.h"


void
find_cmd(MPI_Comm *comm, char *cmd, int need_all, int *found)
{
  int size, rank;
  int count;
  FILE *fp;

  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  /* First, see if cmd exists on all ranks */

  fp = fopen(cmd, "r");
  if (fp == NULL)
    *found = 0;
  else {
    fclose(fp);
    *found = 1;
  }
  MPI_Allreduce(found, &count, 1, MPI_INT, MPI_SUM, MPI_COMM_WORLD);
  if (count == 0) {
    if (rank == 0)
      lamtest_warning(__FILE__, __LINE__, 
		      "WARNING: Strangeness: no rank was able to find \"%s\"\n"
		      "WARNING: I'm aborting this test, but not calling it an error...\n", 
		      cmd);
    return;
  }

  if (need_all == 1 && count != size) {
    if (rank == 0)
      lamtest_warning(__FILE__, __LINE__, 
		      "Not all ranks were able to find:\n\t\"%s\"\n"
		      "You probably don't have a uniform filesystem...?\n"
		      "So I'll skip this test, but not call it a failure.\n",
		      cmd);
    *found = 0;
  }

  /* Make communicators for those with and those without */

  MPI_Comm_split(MPI_COMM_WORLD, *found, 0, comm);

  /* If we don't have it, we can free the comm */

  if (*found == 0)
    MPI_Comm_free(comm);
}
