/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: alltoall.c,v 1.2 2002/10/09 20:55:59 brbarret Exp $
 *
 * Helper function for LAM-specific spawn tests
 */

#include <stdio.h>
#include <stdlib.h>

#include "mpi.h"
#include "lamtest_error.h"
#include "lamtest_spawn.h"


void
all_to_all(MPI_Comm intra)
{
  int size, rank, i;
  int message;
  char hostname[MPI_MAX_PROCESSOR_NAME];

  MPI_Comm_size(intra, &size);
  MPI_Comm_rank(intra, &rank);
  i = MPI_MAX_PROCESSOR_NAME;
  MPI_Get_processor_name(hostname, &i);

  /* First send rank and hostname back to the root for display */

  if (rank == 0) {
    if (verbose)
      printf("Rank 0 running on host %s\n", hostname);
    for (i = 1; i < size; ++i) {
      MPI_Recv(hostname, MPI_MAX_PROCESSOR_NAME, MPI_CHAR, i, name_tag,
	       intra, MPI_STATUS_IGNORE);
      if (verbose)
	printf("Rank %d running on host %s\n", i, hostname);
    }
  } else {
    MPI_Send(hostname, MPI_MAX_PROCESSOR_NAME, MPI_CHAR, 0, name_tag, intra);
  }

  /* Now do an all-to-all, just to verify connectivity */

  for (i = 0; i < size; i++) {
    message = -1;
    if (i == rank)
      continue;
    else if (i < rank) {
      MPI_Send(&rank, 1, MPI_INT, i, ata_tag, intra);
      MPI_Recv(&message, 1, MPI_INT, i, ata_tag, intra, MPI_STATUS_IGNORE);
    } else {
      MPI_Recv(&message, 1, MPI_INT, i, ata_tag, intra, MPI_STATUS_IGNORE);
      MPI_Send(&rank, 1, MPI_INT, i, ata_tag, intra);
    }

    if (message != i)
      lamtest_error(__FILE__, __LINE__, "ERROR: rank %d got message %d from comm rank %d; expected %d\n", rank, message, i, i);
  }
}
