/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: allreduce_smp.c,v 1.1 2003/04/30 20:24:24 jsquyres Exp $
 */
/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************
*/
#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>
#include "lamtest_error.h"

#define MAXLEN 100000
 
int 
main(int argc, char **argv)
{
   int *out, *in, i, j, k;
   int myself, tasks;
   void *attrp;
 
   MPI_Init(&argc,&argv);
   MPI_Comm_rank(MPI_COMM_WORLD,&myself);
   MPI_Comm_size(MPI_COMM_WORLD,&tasks);

   /* See the associatve attribute on MPI_COMM_WORLD so that if the
      SMP algorithms are used, they'll trigger the associative
      algorithm.  Otherwise, this attribute will be ignored. */

   attrp = (void*) 1;
   MPI_Comm_set_attr(MPI_COMM_WORLD, LAM_MPI_SSI_COLL_ASSOCIATIVE, &attrp);

   in = malloc(sizeof(int) * MAXLEN);
   out = malloc(sizeof(int) * MAXLEN);
   if (in == NULL || out == NULL)
     lamtest_error(__FILE__, __LINE__, "Doh!  Rank %d was not able to allocate enough memory.  MPI test aborted!\n", myself);

   for (j = MAXLEN; j <= MAXLEN; j *= 10)  {
      for (i = 0; i < j; i++)  
	out[i] = i;
 
      MPI_Allreduce(out,in,j,MPI_INT,MPI_SUM,MPI_COMM_WORLD);

      for (k = 0; k < j; k++) {
         if (in[k] != k * tasks) {  
	   lamtest_error(__FILE__, __LINE__, "bad answer (%d) at index %d of %d (should be %d)\n", in[k], k, j, k * tasks); 
	   break; 
	 }
      }
   }

   free(in);
   free(out);

   MPI_Barrier(MPI_COMM_WORLD);
   MPI_Finalize();
   return 0;
}
