/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: overtake.c,v 1.5 2002/10/09 20:55:57 brbarret Exp $
 *
 *      HP High Performance Systems Division
 *      (c)Copyright 1999 Hewlett-Packard Co.
 *
 *      $Revision: 1.5 $
 *
 *	Function:	- Program to test that the "no overtaking messages" 
 *		          semantics of point to point communications in MPI 
 *			  is satisfied. A long message is sent using MPI_Send 
 *			  and received using MPI_Recv, followed by lots of 
 *			  short messages sent the same way. Then Send->Irecv,
 *			  Bsend->Recv, Bsend->Irecv, Isend->Recv, and 
 *			  Isend->Irecv are all tried in the same way.
 * 	
 *						Patrick Bridges
 *						bridges@mcs.anl.gov
 *						patrick@CS.MsState.Edu
 */

#include <stdlib.h>
#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"

#define SIZE 	10000

static int src;
static int dest;
static int rank;
static int size;


static void
local_assert(int val1, int val2, char *msg)
 {
  if (val1 != val2)
    lamtest_error(__FILE__, __LINE__, "%s\n", msg);
}

static void
Generate_Data(double *buffer, int buff_size)
 {
  int i;

  for (i = 0; i < buff_size; i++)
    buffer[i] = (double) i + 1;
}

static void
Normal_Test_Send(double *buffer, int buff_size)
 {
  int i, j;

  for (j = 0; j < 2; j++) {
/*
 * send a long message 
 */
    MPI_Send(buffer, (buff_size / 2 - 10), MPI_DOUBLE,
	     dest, 2000, MPI_COMM_WORLD);
    buffer += buff_size / 2 - 10;
/*
 * Followed by 10 short ones 
 */
    for (i = 0; i < 10; i++)
      MPI_Send(buffer++, 1, MPI_DOUBLE, dest, 2000, MPI_COMM_WORLD);
  }
  fflush(stdout);
}

static void
Normal_Test_Recv(double *buffer, int buff_size)
 {
  int i, j;
  MPI_Status Stat;

  for (j = 0; j < 2; j++) {
/*
 * Receive a long message 
 */
    MPI_Recv(buffer, (buff_size / 2 - 10), MPI_DOUBLE, src,
	     2000, MPI_COMM_WORLD, &Stat);
    buffer += buff_size / 2 - 10;
/*
 * Followed by 10 short ones 
 */
    for (i = 0; i < 10; i++)
      MPI_Recv(buffer++, 1, MPI_DOUBLE, src, 2000, MPI_COMM_WORLD, &Stat);
  }
}

static int
Check_Data(double *buffer, int buff_size)
 {
  int i;
  int err = 0;

  for (i = 0; i < buff_size; i++) {
    if (buffer[i] != (double) (i + 1))
      err++;
  }

  local_assert(err, 0, "Buffer data is corrupt");
  return err;
}

static void
Clear_Buffer(double *buffer, int buff_size)
 {
  int i;

  for (i = 0; i < buff_size; i++)
    buffer[i] = -1;
}


int
main(int argc, char *argv[])
 {
  double buffer[SIZE];

  MPI_Init(&argc, &argv);

  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);

  lamtest_need_even(__FILE__, __LINE__);

  if (rank % 2 == 0) {
    src = rank;
    dest = rank + 1;
  } else {
    src = rank - 1;
    dest = rank;
  }

  if (rank == src) {
    Generate_Data(buffer, SIZE);
    Normal_Test_Send(buffer, SIZE);
  } else if (rank == dest) {
    Clear_Buffer(buffer, SIZE);
    Normal_Test_Recv(buffer, SIZE);
    local_assert(Check_Data(buffer, SIZE), 0, "Test 1 failed");
  }

  MPI_Finalize();
  exit(0);
}
