/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: nonblocking.c,v 1.3 2002/10/09 20:55:57 brbarret Exp $
 *
 * Test some nonblocking messages, and check for received data values.
 * I think this one originally came from HP/MPI and/or MPICH.
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


void
foo()
{
  int i_rbuf1;
  int i_rbuf2;
  int i_sbuf1;
  int i_sbuf2;
  int i;
  int my_rank;
  MPI_Status status;
  int num_errors;
  int nprocs;

  MPI_Request send_req1;
  MPI_Request send_req2;
  MPI_Request recv_req1;
  MPI_Request recv_req2;

  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);

  lamtest_check_size(__FILE__, __LINE__, 2, 1);

  num_errors = 0;

  /* 
   * Two messages are passed between each pair of processes.
   * The messages are distinguished both by tag and content. 
   * 
   * Each process loops through all other ranks.  For each
   * other rank it does two Irecvs then two Isends, then 
   * waits on the two recv requests.  It then checks
   * that it recv'd the correct data.  Finally it waits
   * on the two send requests.
   */

  for (i = 0; i < nprocs; i = i + 1) {
    if (i != my_rank) {
      MPI_Irecv(&i_rbuf2, 1, MPI_INT, i, 30 * (i + 1),
		MPI_COMM_WORLD, &recv_req2);
      MPI_Irecv(&i_rbuf1, 1, MPI_INT, i, 20 * (i + 1),
		MPI_COMM_WORLD, &recv_req1);

      i_sbuf1 = 100 * my_rank + i;
      i_sbuf2 = i_sbuf1 + 42;

      MPI_Isend(&i_sbuf1, 1, MPI_INT, i, 20 * (my_rank + 1),
		MPI_COMM_WORLD, &send_req1);
      MPI_Wait(&send_req1, &status);

      MPI_Isend(&i_sbuf2, 1, MPI_INT, i, 30 * (my_rank + 1),
		MPI_COMM_WORLD, &send_req2);
      MPI_Wait(&send_req2, &status);
      MPI_Wait(&recv_req1, &status);
      MPI_Wait(&recv_req2, &status);

      if (i_rbuf1 != (100 * i + my_rank))
	num_errors++;
      if (i_rbuf2 != (100 * i + my_rank + 42))
	num_errors++;
    }
  }

  if (num_errors != 0)
    lamtest_error(__FILE__, __LINE__, "Simple Nonblocking: Test failed in rank %d with %d errors.\n",
		  my_rank, num_errors);
}


int
main(int argc, char *argv[])
{
  MPI_Init(&argc, &argv);
  foo();
  MPI_Finalize();
  return 0;
}
