/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: big.c,v 1.11 2003/06/27 02:07:36 jsquyres Exp $
 *
 * Test some long, big messages.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mpi.h>

#include <lamtest_error.h>

#define SIZE 262144
#define SMALL_SIZE 65537
#define ITERATIONS 5


int
main(int argc, char* argv[])
{
  char *sendbuf;
  char *recvbuf;
  int i, j, k, tag = 200;
  int my_rank, pos, size;
  int num = 0;
  MPI_Request *reqs;
  int max_msg_size;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);

  /* Look for overrides for RPI's that can't allocate much "special"
     memory */

  max_msg_size = SIZE;
  if (getenv("LAM_MPI_test_small_mem") != NULL)
    max_msg_size = SMALL_SIZE;
  if (my_rank == 0)
    printf("NOTICE: Using max message size: %d\n", max_msg_size);

  sendbuf = malloc(max_msg_size * size);
  recvbuf = malloc(max_msg_size * size);
  reqs = malloc(sizeof(MPI_Request) * size * 2);

  if (my_rank == 0) {
    printf("It is not unusual for this test to take several minutes,\n"
	   "particularly on slow networks and/or in lamd mode.\n"
	   "Please be patient.\n");
    fflush(stdout);
  }

  /* Initialize the sending buffer */

  memset(sendbuf, my_rank % 127, max_msg_size * size);

  /* All to all pattern, long messages.  Should not deadlock.  Lots of
     unexepected messages.  Repeat the test several times, just to
     make it harder. */

  lamtest_progress_start(ITERATIONS);
  for (k = 0; k < ITERATIONS; ++k) {
    memset(recvbuf, -1, max_msg_size * size);

    num = 0;
    for (i = 0; i < size; ++i)
      if (i != my_rank) {
	MPI_Isend(&sendbuf[i * max_msg_size], max_msg_size, 
                  MPI_CHAR, i, tag, MPI_COMM_WORLD, &reqs[num++]);
      }
    
    for (i = 0; i < size; ++i)
      if (i != my_rank) {
	MPI_Irecv(&recvbuf[i * max_msg_size], max_msg_size, 
                  MPI_CHAR, i, tag, MPI_COMM_WORLD, &reqs[num++]);
      }

    /* Make it all happen */

    MPI_Waitall(num, reqs, MPI_STATUSES_IGNORE);

    /* Check to ensure that we got the right stuff */

    for (i = 0; i < size; ++i) {
      if (i != my_rank) 
	for (pos = i * max_msg_size, j = 0; j < max_msg_size; ++j, ++pos) {
	  if (recvbuf[pos] != (i % 127)) {
	    lamtest_error(__FILE__, __LINE__, 
			  "Got wrong value from rank %d at position %d, "
			  "got %d, expected %d\n", i, pos, recvbuf[pos], 
			  (i % 127));
	  }
	}
    }

    lamtest_progress(k + 1);
  }
  lamtest_progress_end();

  free(sendbuf);
  free(recvbuf);
  free(reqs);
  
  MPI_Finalize();
  return 0;
}
