/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: alltoall2.c,v 1.5 2003/06/02 02:25:35 jsquyres Exp $
 *
 * Test sending big messages in a naieve all-to-all pattern
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mpi.h"

#include "lamtest_error.h"

#define SIZE 32768



static void check(char *buffer, int size, char val);
int rank;


int
main(int argc, char* argv[])
{
  int i;
  int size;
  int tag = 201;

  char *send_buffer;
  char *recv_buffer;
  MPI_Request *send_reqs;
  MPI_Request *recv_reqs;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  send_buffer = (char*) malloc(SIZE * size);
  recv_buffer = (char*) malloc(SIZE * size);
  memset(send_buffer, rank % 127, SIZE * size);
  memset(recv_buffer, 0, SIZE * size);

  send_reqs = malloc(size * sizeof(MPI_Request) * 2);
  recv_reqs = &send_reqs[size];

  for (i = 0; i < size; ++i) {
    if (i == rank) {
      /* skipping send to myself */
      send_reqs[rank] = MPI_REQUEST_NULL;
      recv_reqs[rank] = MPI_REQUEST_NULL;
    } else {
      MPI_Isend(&send_buffer[i * SIZE], SIZE, MPI_CHAR, i, tag, 
		MPI_COMM_WORLD, &send_reqs[i]);
      MPI_Irecv(&recv_buffer[i * SIZE], SIZE, MPI_CHAR, i, tag, 
		MPI_COMM_WORLD, &recv_reqs[i]);
    }
  }

  MPI_Waitall(size * 2, send_reqs, MPI_STATUSES_IGNORE);

  for (i = 0; i < size; ++i) {
    if (i != rank) {
      check(&recv_buffer[i * SIZE], SIZE, i % 127);
    }
  }

  free(send_reqs);
  free(recv_buffer);
  free(send_buffer);
  MPI_Finalize();
  return 0;
}




static void
check(char *buffer, int size, char val)
{
  int i;

  for (i = 1; i < size; ++i)
    if (buffer[i] != val) {
      lamtest_error(__FILE__, __LINE__, 
		    "Rank %d: found value %d at pos %d when expecting value %d\n",
		    rank, buffer[i], i, val);
    }
}


