/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: alltoall.c,v 1.5 2003/06/02 02:25:35 jsquyres Exp $
 *
 * Test sending big messages in a naieve all-to-all pattern
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mpi.h"

#include "lamtest_error.h"

#define SIZE 1048576



static void check(char *buffer, int size, char val);
int rank;


int
main(int argc, char* argv[])
{
  int i;
  int size;
  int tag = 201;

  char *send_buffer;
  char *recv_buffer;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  send_buffer = (char*) malloc(SIZE);
  recv_buffer = (char*) malloc(SIZE);
  memset(send_buffer, rank % 127, SIZE);

  for (i = 0; i < size; i++) {
    if (i == rank) {
      /* skipping send to myself */
      continue;  
    } else if (i < rank) {
      memset(recv_buffer, 0, SIZE);
      MPI_Send(send_buffer, SIZE, MPI_CHAR, i, tag, MPI_COMM_WORLD);
      MPI_Recv(recv_buffer, SIZE, MPI_CHAR, i, tag, MPI_COMM_WORLD, 
	       MPI_STATUS_IGNORE);
      check(recv_buffer, SIZE, i % 127);
    } else {
      memset(recv_buffer, 0, SIZE);
      MPI_Recv(recv_buffer, SIZE, MPI_CHAR, i, tag, MPI_COMM_WORLD, 
	       MPI_STATUS_IGNORE);
      check(recv_buffer, SIZE, i % 127);
      MPI_Send(send_buffer, SIZE, MPI_CHAR, i, tag, MPI_COMM_WORLD);
    }
  }

  free(recv_buffer);
  free(send_buffer);
  MPI_Finalize();
  return 0;
}




static void
check(char *buffer, int size, char val)
{
  int i;

  for (i = 1; i < size; ++i)
    if (buffer[i] != val) {
      lamtest_error(__FILE__, __LINE__, 
		    "Rank %d: found value %d at pos %d when expecting value %d\n",
		    rank, buffer[i], i, val);
    }
}


