/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: file_status_get_count.c,v 1.9 2002/10/09 20:55:55 brbarret Exp $
 *
 * This program origianlly written by Nina Thiessen.  Modified by Jeff
 * Squyres to become part of the LAM test suite.
 *
 * Test program to ensure that ROMIO is setting the raw number of
 * bytes received properly in an MPI_Status object correctly.  This is
 * tested because ROMIO doesn't do it by default -- we had to make a
 * small hack in ROMIO to make this work properly (since ROMIO doesn't
 * natively understand the hidden members of LAM's MPI_Status object).
 * See romio/README_LAM.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "mpi.h"

#include "lamtest_error.h"

int 
main(int argc, char *argv[])
{
  int myrank, numprocs, bufsize, *buf, count, i, ret;
  MPI_File thefile;
  MPI_Status status;
  MPI_Offset filesize;
  FILE *fp;
  char filename[256];

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
  MPI_Comm_size(MPI_COMM_WORLD, &numprocs);

  /* Do this on every node, because in a testing environment, we can't
     assume a common filesystem */

  sprintf(filename, "lam_testfile.%d", myrank);
  fp = fopen(filename, "w");
  for (i = 0; i < numprocs * 50; ++i)
    fwrite(&i, sizeof(int), 1, fp);
  fclose(fp);

  ret = MPI_File_open(MPI_COMM_SELF, filename, MPI_MODE_RDONLY,
		      MPI_INFO_NULL, &thefile);
  if (ret != MPI_SUCCESS)
    lamtest_error(__FILE__, __LINE__, "Error in MPI_File_open!\n");
  
  ret = MPI_File_get_size(thefile, &filesize); /* in bytes */
  if (ret != MPI_SUCCESS)
    lamtest_error(__FILE__, __LINE__, "Error in MPI_File_get_size!\n");
  filesize = filesize / sizeof(int); /* in # of ints */
  bufsize = filesize / numprocs;  /* local num of ints to read */
  buf = (int *) malloc(bufsize * sizeof(int));
  if (buf == NULL)
    lamtest_error(__FILE__, __LINE__, "Doh!  Rank %d was not able to allocate enough memory.  MPI test aborted!\n", myrank);

  status.st_length = 20;
  ret = MPI_File_set_view(thefile, myrank * bufsize * sizeof(int), MPI_INT,
			  MPI_INT, "native", MPI_INFO_NULL);
  if (ret != MPI_SUCCESS)
    lamtest_error(__FILE__, __LINE__, "Error in MPI_File_set_view!\n");

  ret = MPI_File_read(thefile, buf, bufsize, MPI_INT, &status);
  if (ret != MPI_SUCCESS)
    lamtest_error(__FILE__, __LINE__, "Error in MPI_File_read!\n");

  MPI_Get_count(&status, MPI_INT, &count);
  if (bufsize != count)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Get_count returned the incorrect value.\n"
		  "Was expecing: %d, MPI_Get_count returned %d\n", bufsize, count);

  MPI_File_close(&thefile);
  free(buf);

  /* Delete the testfile */

  unlink(filename);

  MPI_Finalize();
  return 0;
}
