/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 50_getnkeys_cxx.cc,v 1.4 2003/05/04 13:47:18 jsquyres Exp $
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


int 
main(int argc, char** argv)
{
  const char *key1 = "key1";
  const char *key2 = "key2key2";
  const char *key3 = "key3key3key3";
  const char *value1 = "value1";
  const char *value2 = "value2 value2";
  const char *value3 = "value3 value3 value3";
  int nkeys;

  MPI::Init(argc, argv);

  /* Pretty simple test -- call MPI_Info_get_nkeys and ensure that it
     returns the right number */

  MPI::Info info = MPI::Info::Create();

  if ((nkeys = info.Get_nkeys()) != 0)
    lamtest_error(__FILE__, __LINE__,
		  "Info::Get_nkeys reported %d on an empty MPI::Info handle\n",
		  nkeys);

  info.Set(key1, value2);
  info.Set(key1, value1);
  info.Set(key2, value2);
  info.Set(key3, value3);

  if ((nkeys = info.Get_nkeys()) != 3)
    lamtest_error(__FILE__, __LINE__,
		  "Info::Get_nkeys reported %d; expected 3\n", nkeys);

  /* Free it so that we can be bcheck clean */

  info.Free();

  MPI::Finalize();
  return 0;
}
