/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 50_getnkeys.c,v 1.3 2003/05/04 13:47:18 jsquyres Exp $
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


int
main(int argc, char **argv)
{
  MPI_Info info;
  char *key1 = "key1";
  char *key2 = "key2key2";
  char *key3 = "key3key3key3";
  char *value1 = "value1";
  char *value2 = "value2 value2";
  char *value3 = "value3 value3 value3";
  int nkeys;

  MPI_Init(&argc, &argv);

  /* Pretty simple test -- call MPI_Info_get_nkeys and ensure that it
     returns the right number */

  MPI_Info_create(&info);

  nkeys = -1;
  MPI_Info_get_nkeys(info, &nkeys);
  if (nkeys != 0)
    lamtest_error(__FILE__, __LINE__,
		  "Info_get_nkeys reported %d on an empty MPI_Info handle\n",
		  nkeys);

  MPI_Info_set(info, key1, value2);
  MPI_Info_set(info, key1, value1);
  MPI_Info_set(info, key2, value2);
  MPI_Info_set(info, key3, value3);

  MPI_Info_get_nkeys(info, &nkeys);
  if (nkeys != 3)
    lamtest_error(__FILE__, __LINE__,
		  "Info_get_nkeys reported %d; expected 3\n", nkeys);

  /* Free it so that we are bcheck clean */

  MPI_Info_free(&info);

  MPI_Finalize();
  return 0;
}
