/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 40_getvaluelen.c,v 1.3 2003/05/04 13:47:18 jsquyres Exp $
 */

#include <stdio.h>
#include <string.h>
#include <mpi.h>

#include "lamtest_error.h"


static void test_info(MPI_Info *info, char *key, char *value);


int
main(int argc, char **argv)
{
  MPI_Info info1, info2, info3;
  char *key1 = "key1";
  char *key2 = "key2key2";
  char *key3 = "key3key3key3";
  char *value1 = "value1";
  char *value2 = "value2 value2";
  char *value3 = "value3 value3 value3";

  MPI_Init(&argc, &argv);

  /* Pretty simple test -- call MPI_Info_set followed by MPI_Info_get
     and compare that the value that we get out is the same as the one
     that we put in */

  test_info(&info1, key1, value1);
  test_info(&info2, key2, value2);
  test_info(&info3, key3, value3);

  /* Free them so that we are bcheck clean */

  MPI_Info_free(&info1);
  MPI_Info_free(&info2);
  MPI_Info_free(&info3);

  MPI_Finalize();
  return 0;
}


/*
 * Abort on failure
 */
static void
test_info(MPI_Info *info, char *key, char *value)
{
  int len = 0, expected = -73, flag = 0;

  MPI_Info_create(info);
  MPI_Info_set(*info, key, value);
  MPI_Info_get_valuelen(*info, key, &len, &flag);

  if (flag == 0 || strlen(value) != len)
    lamtest_error(__FILE__, __LINE__, 
		  "Info_get_valuelen obtained len %d, expected %d\n", 
		  len, strlen(value));

  len = expected;
  MPI_Info_get_valuelen(*info, "bogus", &len, &flag);
  if (flag == 1)
    lamtest_error(__FILE__, __LINE__, 
		  "Info_get_valuelen for bogus key reported flag==1\n");
  else if (len != expected)
    lamtest_error(__FILE__, __LINE__, 
		  "Info_get_valuelen for bogus key reset len; "
		  "got %d, expected %d\n", len, expected);
}
