/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 30_get_cxx.cc,v 1.5 2003/05/07 17:38:41 jsquyres Exp $
 */

#include <stdio.h>
#include <string.h>
#include <mpi.h>

#include "lamtest_error.h"


static void test_info(MPI::Info& info, const char* key, const char* value);


int 
main(int argc, char** argv)
{
  const char *key1 = "key1";
  const char *key2 = "key2key2";
  const char *key3 = "key3key3key3";
  const char *value1 = "value1";
  const char *value2 = "value2 value2";
  const char *value3 = "value3 value3 value3";

  MPI::Init(argc, argv);

  /* Pretty simple test -- call MPI_Info_set followed by MPI_Info_get
     and compare that the value that we get out is the same as the one
     that we put in */
 
  MPI::Info info1, info2, info3;
  test_info(info1, key1, value1);
  test_info(info2, key2, value2);
  test_info(info3, key3, value3);

  /* Free them so that we can be bcheck clean */

  info1.Free();
  info2.Free();
  info3.Free();

  MPI::Finalize();
  return 0;
}


/*
 * Abort on failure
 */

static void
test_info(MPI::Info& info, const char* key, const char* value)
{
  char get_value[MPI_MAX_INFO_KEY];

  info = MPI::Info::Create();
  info.Set(key, "bogus");
  info.Set(key, value);
  if (!info.Get(key, MPI_MAX_INFO_KEY - 1, get_value) ||
      strcmp(value, get_value) != 0)
    lamtest_error(__FILE__, __LINE__, 
		  "Info::Get obtained value \"%s\", expected \"%s\"\n", 
		  get_value, value);

  if (info.Get("bogus", MPI_MAX_INFO_KEY - 1, get_value))
    lamtest_error(__FILE__, __LINE__, 
		  "Info::Get for bogus key reported flag==1\n");
}
