/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 20_delete_cxx.cc,v 1.5 2003/05/04 13:47:17 jsquyres Exp $
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


int 
main(int argc, char** argv)
{
  const char *key1 = "key1";
  const char *key2 = "key2key2";
  const char *key3 = "key3key3key3";
  const char *value1 = "value1";
  const char *value2 = "value2 value2";
  const char *value3 = "value3 value3 value3";

  MPI::Init(argc, argv);

  /* Pretty simple test -- call MPI::Info::Delete and ensure that it
     doesn't return an error */

  MPI::Info info1 = MPI::Info::Create();
  MPI::Info info2 = MPI::Info::Create();
  MPI::Info info3 = MPI::Info::Create();

  info1.Set(key1, value1);
  info2.Set(key2, value2);
  info3.Set(key3, value3);

  info1.Delete(key1);
  info2.Delete(key2);
  info3.Delete(key3);

  /* Free them so that we can be bcheck clean */

  info1.Free();
  info2.Free();
  info3.Free();

  MPI::Finalize();
  return 0;
}
