/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 20_delete.c,v 1.3 2003/05/04 13:47:16 jsquyres Exp $
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


int
main(int argc, char **argv)
{
  MPI_Info info1, info2, info3;
  char *key1 = "key1";
  char *key2 = "key2key2";
  char *key3 = "key3key3key3";
  char *value1 = "value1";
  char *value2 = "value2 value2";
  char *value3 = "value3 value3 value3";

  MPI_Init(&argc, &argv);

  /* Pretty simple test -- call MPI_Info_delete and ensure that it
     doesn't return an error */

  MPI_Info_create(&info1);
  MPI_Info_create(&info2);
  MPI_Info_create(&info3);

  MPI_Info_set(info1, key1, value1);
  MPI_Info_set(info2, key2, value2);
  MPI_Info_set(info3, key3, value3);

  MPI_Info_delete(info1, key1);
  MPI_Info_delete(info2, key2);
  MPI_Info_delete(info3, key3);

  /* Free them so that we are bcheck clean */

  MPI_Info_free(&info1);
  MPI_Info_free(&info2);
  MPI_Info_free(&info3);

  MPI_Finalize();
  return 0;
}
