/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 00_create_cxx.cc,v 1.4 2003/05/04 13:47:15 jsquyres Exp $
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


int 
main(int argc, char** argv)
{
  MPI::Init(argc, argv);

  /* Pretty simple test -- call MPI::Info::Create and ensure that it
     doesn't return an error */

  MPI::Info info1 = MPI::Info::Create();
  MPI::Info info2 = MPI::Info::Create();
  MPI::Info info3 = MPI::Info::Create();

  /* Free them so that we can be bcheck clean */

  info1.Free();
  info2.Free();
  info3.Free();

  MPI::Finalize();
  return 0;
}
