/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 00_create.c,v 1.3 2003/05/04 13:47:15 jsquyres Exp $
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


int
main(int argc, char **argv)
{
  MPI_Info info1, info2, info3;

  MPI_Init(&argc, &argv);

  /* Pretty simple test -- call MPI_Info_create and ensure that it
     doesn't return an error */

  MPI_Info_create(&info1);
  MPI_Info_create(&info2);
  MPI_Info_create(&info3);

  /* Free them so that we are bcheck clean */

  MPI_Info_free(&info1);
  MPI_Info_free(&info2);
  MPI_Info_free(&info3);

  MPI_Finalize();
  return 0;
}
