/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: is_thr_main_mt.c,v 1.1 2002/10/21 18:49:27 brbarret Exp $
 */

#include <stdio.h>
#include "mpi.h"

#include "lamtest_error.h"

#include "lamthreads.h"

void*
test_func(void *foo)
{
  int flag;

  MPI_Is_thread_main(&flag);

  return (void*) flag;
}

int 
main(int argc, char**argv)
{
  int flag, provided, err;

  lam_thread_t newthread;

  /* To make my life easier - make OS main thread == MPI main thread */
  err = MPI_Init_thread(&argc, &argv, MPI_THREAD_SERIALIZED, &provided);
  if (err != MPI_SUCCESS)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Init_thread did not return MPI_SUCCESS\n");

  if (provided != MPI_THREAD_SERIALIZED)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Init_thread did not return MPI_THREAD_SINGLE\n");

  MPI_Is_thread_main(&flag);
  if (flag != 1)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Is_thread_main did not return 1\n");

  /* Ok, we've gone through sanity checking...  Time for the real fun.. */
  err = lam_thread_create(&newthread, test_func, 0);
  if (err != 0)
    lamtest_error(__FILE__, __LINE__, "ERROR: lam_thread_create failed\n");

  /* Test again, just in case */
  MPI_Is_thread_main(&flag);
  if (flag != 1)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Is_thread_main did not return 1\n");

  /* pick up results */
  err = lam_thread_join(newthread, (void**) &flag);
  if (err != 0)
    lamtest_error(__FILE__, __LINE__, "ERROR: lam_thread_join failed\n");

  if (flag != 0)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Is_thread_main did not return 0\n");

  MPI_Finalize();
  return 0;
}
