/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: init_thread_multiple.c,v 1.2 2003/05/29 13:45:40 jsquyres Exp $
 */

#include <stdio.h>
#include <mpi.h>

#include <lamtest_error.h>


int 
main(int argc, char**argv)
{
  int rank;
  int provided, err;

  err = MPI_Init_thread(&argc, &argv, MPI_THREAD_MULTIPLE, &provided);
  if (err != MPI_SUCCESS)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Init_thread did not return MPI_SUCCESS\n");

  if (provided < MPI_THREAD_SINGLE || provided > MPI_THREAD_MULTIPLE)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Init_thread returned an illegal value\n");

  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  if (rank == 0)
    printf("PASS: MPI_Init_thread with MPI_THREAD_MULTIPLE returned MPI_THREAD_%s\n",
           (provided == MPI_THREAD_SINGLE) ? "SINGLE" :
           (provided == MPI_THREAD_FUNNELED) ? "FUNNELED" :
           (provided == MPI_THREAD_SERIALIZED) ? "SERIALIZED" : "MULTIPLE");

  MPI_Finalize();
  return 0;
}
