/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: init_thread_funneled.c,v 1.1 2002/10/21 18:49:27 brbarret Exp $
 */ 
#include <stdio.h>
#include "mpi.h"

#include "lamtest_error.h"

int 
main(int argc, char**argv)
{
  int provided, err;

  err = MPI_Init_thread(&argc, &argv, MPI_THREAD_FUNNELED, &provided);
  if (err != MPI_SUCCESS)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Init_thread did not return MPI_SUCCESS\n");

  if (provided != MPI_THREAD_FUNNELED)
    lamtest_error(__FILE__, __LINE__, "ERROR: MPI_Init_thread did not return MPI_THREAD_SINGLE\n");

  MPI_Finalize();
  return 0;
}
