/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame.
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.
 *                         All rights reserved.
 *
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: init_thread_cxx.cc,v 1.8 2003/04/24 09:06:05 adharurk Exp $
 */

#include <stdio.h>
#include "mpi.h"

#include "lamtest_error.h"

int 
main(int argc, char**argv)
{
  int provided;

  provided = MPI::Init_thread(argc, argv, MPI_THREAD_SINGLE);
  if (provided != MPI_THREAD_SINGLE) {
    lamtest_error(__FILE__, __LINE__,
		  "Expected MPI_THREAD_SINGLE got %d", provided);
  }

  MPI::Finalize();
  return 0;
}
